/*
 * Decompiled with CFR 0.152.
 */
package com.deep007.mitmproxyjava.modle;

import com.deep007.mitmproxyjava.MitmRequest;
import com.deep007.mitmproxyjava.modle.FlowHeaders;
import com.google.protobuf.ByteString;
import java.nio.charset.Charset;
import java.util.Map;

public final class FlowRequest {
    public static final String CLASS_NAME = FlowRequest.class.getName();
    private String url;
    private String method;
    private final FlowHeaders headers;
    private byte[] content;

    public static FlowRequest create(MitmRequest request) {
        byte[] content = null;
        if (request.getContent() != null) {
            content = request.getContent().toByteArray();
        }
        return new FlowRequest(request.getUrl(), request.getMethod(), new FlowHeaders(request.getHeadersList()), content);
    }

    public final MitmRequest getMitmRequest() {
        MitmRequest.Builder builder = MitmRequest.newBuilder().setUrl(this.url).setMethod(this.method).addAllHeaders(this.headers.getMitmHeaders());
        if (this.content != null) {
            builder.setContent(ByteString.copyFrom((byte[])this.content));
        }
        return builder.build();
    }

    public FlowRequest(String url, String method, FlowHeaders headers, byte[] content) {
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.content = content;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentAsString() {
        if (this.content == null) {
            return null;
        }
        return this.getContentAsString(Charset.forName("UTF-8"));
    }

    public String getContentAsString(Charset charset) {
        if (this.content == null) {
            return null;
        }
        return new String(this.content, charset);
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setContentAsString(String content) {
        this.content = content.getBytes(Charset.forName("UTF-8"));
    }

    public void setContentAsString(String content, Charset charset) {
        this.content = content.getBytes(charset);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name);
    }
}

