/*
 * Decompiled with CFR 0.152.
 */
package com.descope.model.auth;

import com.descope.sdk.auth.AuthenticationService;
import com.descope.sdk.auth.EnchantedLinkService;
import com.descope.sdk.auth.MagicLinkService;
import com.descope.sdk.auth.OAuthService;
import com.descope.sdk.auth.OTPService;
import com.descope.sdk.auth.PasswordService;
import com.descope.sdk.auth.SAMLService;
import com.descope.sdk.auth.TOTPService;

public class AuthenticationServices {
    AuthenticationService authService;
    OTPService otpService;
    SAMLService samlService;
    TOTPService totpService;
    OAuthService oauthService;
    PasswordService passwordService;
    MagicLinkService magicLinkService;
    EnchantedLinkService enchantedLinkService;

    AuthenticationServices(AuthenticationService authService, OTPService otpService, SAMLService samlService, TOTPService totpService, OAuthService oauthService, PasswordService passwordService, MagicLinkService magicLinkService, EnchantedLinkService enchantedLinkService) {
        this.authService = authService;
        this.otpService = otpService;
        this.samlService = samlService;
        this.totpService = totpService;
        this.oauthService = oauthService;
        this.passwordService = passwordService;
        this.magicLinkService = magicLinkService;
        this.enchantedLinkService = enchantedLinkService;
    }

    public static AuthenticationServicesBuilder builder() {
        return new AuthenticationServicesBuilder();
    }

    public AuthenticationService getAuthService() {
        return this.authService;
    }

    public OTPService getOtpService() {
        return this.otpService;
    }

    public SAMLService getSamlService() {
        return this.samlService;
    }

    public TOTPService getTotpService() {
        return this.totpService;
    }

    public OAuthService getOauthService() {
        return this.oauthService;
    }

    public PasswordService getPasswordService() {
        return this.passwordService;
    }

    public MagicLinkService getMagicLinkService() {
        return this.magicLinkService;
    }

    public EnchantedLinkService getEnchantedLinkService() {
        return this.enchantedLinkService;
    }

    public static class AuthenticationServicesBuilder {
        private AuthenticationService authService;
        private OTPService otpService;
        private SAMLService samlService;
        private TOTPService totpService;
        private OAuthService oauthService;
        private PasswordService passwordService;
        private MagicLinkService magicLinkService;
        private EnchantedLinkService enchantedLinkService;

        AuthenticationServicesBuilder() {
        }

        public AuthenticationServicesBuilder authService(AuthenticationService authService) {
            this.authService = authService;
            return this;
        }

        public AuthenticationServicesBuilder otpService(OTPService otpService) {
            this.otpService = otpService;
            return this;
        }

        public AuthenticationServicesBuilder samlService(SAMLService samlService) {
            this.samlService = samlService;
            return this;
        }

        public AuthenticationServicesBuilder totpService(TOTPService totpService) {
            this.totpService = totpService;
            return this;
        }

        public AuthenticationServicesBuilder oauthService(OAuthService oauthService) {
            this.oauthService = oauthService;
            return this;
        }

        public AuthenticationServicesBuilder passwordService(PasswordService passwordService) {
            this.passwordService = passwordService;
            return this;
        }

        public AuthenticationServicesBuilder magicLinkService(MagicLinkService magicLinkService) {
            this.magicLinkService = magicLinkService;
            return this;
        }

        public AuthenticationServicesBuilder enchantedLinkService(EnchantedLinkService enchantedLinkService) {
            this.enchantedLinkService = enchantedLinkService;
            return this;
        }

        public AuthenticationServices build() {
            return new AuthenticationServices(this.authService, this.otpService, this.samlService, this.totpService, this.oauthService, this.passwordService, this.magicLinkService, this.enchantedLinkService);
        }

        public String toString() {
            return "AuthenticationServices.AuthenticationServicesBuilder(authService=" + this.authService + ", otpService=" + this.otpService + ", samlService=" + this.samlService + ", totpService=" + this.totpService + ", oauthService=" + this.oauthService + ", passwordService=" + this.passwordService + ", magicLinkService=" + this.magicLinkService + ", enchantedLinkService=" + this.enchantedLinkService + ")";
        }
    }
}

