/*
 * Decompiled with CFR 0.152.
 */
package com.descope.model.jwt;

import com.descope.model.auth.AuthParams;
import com.descope.model.client.Client;
import java.security.Key;
import java.util.Map;

public class Provider {
    private Client client;
    private AuthParams authParams;
    private Key providedKey;
    private Map<String, Key> keyMap;

    Provider(Client client, AuthParams authParams, Key providedKey, Map<String, Key> keyMap) {
        this.client = client;
        this.authParams = authParams;
        this.providedKey = providedKey;
        this.keyMap = keyMap;
    }

    public static ProviderBuilder builder() {
        return new ProviderBuilder();
    }

    public Client getClient() {
        return this.client;
    }

    public AuthParams getAuthParams() {
        return this.authParams;
    }

    public Key getProvidedKey() {
        return this.providedKey;
    }

    public Map<String, Key> getKeyMap() {
        return this.keyMap;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setAuthParams(AuthParams authParams) {
        this.authParams = authParams;
    }

    public void setProvidedKey(Key providedKey) {
        this.providedKey = providedKey;
    }

    public void setKeyMap(Map<String, Key> keyMap) {
        this.keyMap = keyMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Provider)) {
            return false;
        }
        Provider other = (Provider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Client this$client = this.getClient();
        Client other$client = other.getClient();
        if (this$client == null ? other$client != null : !((Object)this$client).equals(other$client)) {
            return false;
        }
        AuthParams this$authParams = this.getAuthParams();
        AuthParams other$authParams = other.getAuthParams();
        if (this$authParams == null ? other$authParams != null : !((Object)this$authParams).equals(other$authParams)) {
            return false;
        }
        Key this$providedKey = this.getProvidedKey();
        Key other$providedKey = other.getProvidedKey();
        if (this$providedKey == null ? other$providedKey != null : !this$providedKey.equals(other$providedKey)) {
            return false;
        }
        Map<String, Key> this$keyMap = this.getKeyMap();
        Map<String, Key> other$keyMap = other.getKeyMap();
        return !(this$keyMap == null ? other$keyMap != null : !((Object)this$keyMap).equals(other$keyMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Provider;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Client $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : ((Object)$client).hashCode());
        AuthParams $authParams = this.getAuthParams();
        result = result * 59 + ($authParams == null ? 43 : ((Object)$authParams).hashCode());
        Key $providedKey = this.getProvidedKey();
        result = result * 59 + ($providedKey == null ? 43 : $providedKey.hashCode());
        Map<String, Key> $keyMap = this.getKeyMap();
        result = result * 59 + ($keyMap == null ? 43 : ((Object)$keyMap).hashCode());
        return result;
    }

    public String toString() {
        return "Provider(client=" + this.getClient() + ", authParams=" + this.getAuthParams() + ", providedKey=" + this.getProvidedKey() + ", keyMap=" + this.getKeyMap() + ")";
    }

    public static class ProviderBuilder {
        private Client client;
        private AuthParams authParams;
        private Key providedKey;
        private Map<String, Key> keyMap;

        ProviderBuilder() {
        }

        public ProviderBuilder client(Client client) {
            this.client = client;
            return this;
        }

        public ProviderBuilder authParams(AuthParams authParams) {
            this.authParams = authParams;
            return this;
        }

        public ProviderBuilder providedKey(Key providedKey) {
            this.providedKey = providedKey;
            return this;
        }

        public ProviderBuilder keyMap(Map<String, Key> keyMap) {
            this.keyMap = keyMap;
            return this;
        }

        public Provider build() {
            return new Provider(this.client, this.authParams, this.providedKey, this.keyMap);
        }

        public String toString() {
            return "Provider.ProviderBuilder(client=" + this.client + ", authParams=" + this.authParams + ", providedKey=" + this.providedKey + ", keyMap=" + this.keyMap + ")";
        }
    }
}

