/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.flow.Flow;
import com.descope.model.flow.FlowResponse;
import com.descope.model.flow.Screen;
import com.descope.model.flow.Theme;
import com.descope.model.mgmt.ManagementParams;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.FlowService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

class FlowServiceImpl
extends ManagementsBase
implements FlowService {
    FlowServiceImpl(Client client, ManagementParams managementParams) {
        super(client, managementParams);
    }

    @Override
    public FlowResponse exportFlow(String flowID) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)flowID)) {
            throw ServerCommonException.invalidArgument("FlowID");
        }
        Map<String, String> request = Map.of("flowId", flowID);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/flow/export"), request, FlowResponse.class);
    }

    @Override
    public FlowResponse importFlow(String flowID, Flow flow, List<Screen> screens) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)flowID)) {
            throw ServerCommonException.invalidArgument("FlowID");
        }
        Map<String, List<Screen>> request = Map.of("flowId", flowID, "flow", flow, "screens", screens);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/flow/import"), request, FlowResponse.class);
    }

    @Override
    public Theme exportTheme() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/theme/export"), null, Theme.class);
    }

    @Override
    public Theme importTheme(Theme theme) throws DescopeException {
        if (Objects.isNull(theme)) {
            throw ServerCommonException.invalidArgument("Theme");
        }
        Map<String, Theme> request = Map.of("theme", theme);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/theme/import"), request, Theme.class);
    }
}

