/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.mgmt.ManagementParams;
import com.descope.model.tenant.Tenant;
import com.descope.model.tenant.response.GetAllTenantsResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.TenantService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class TenantServiceImpl
extends ManagementsBase
implements TenantService {
    TenantServiceImpl(Client client, ManagementParams managementParams) {
        super(client, managementParams);
    }

    @Override
    public String create(String name, List<String> selfProvisioningDomains) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("name");
        }
        Tenant tenant = new Tenant("", name, selfProvisioningDomains);
        return this.create(tenant);
    }

    @Override
    public void createWithId(String id, String name, List<String> selfProvisioningDomains) throws DescopeException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{id, name})) {
            throw ServerCommonException.invalidArgument("id or name");
        }
        Tenant tenant = new Tenant(id, name, selfProvisioningDomains);
        this.create(tenant);
    }

    private String create(Tenant tenant) {
        URI createTenantUri = this.composeCreateTenantUri();
        ApiProxy apiProxy = this.getApiProxy();
        Tenant savedTenant = apiProxy.post(createTenantUri, tenant, Tenant.class);
        return savedTenant.getId();
    }

    @Override
    public void update(String id, String name, List<String> selfProvisioningDomains) throws DescopeException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{id, name})) {
            throw ServerCommonException.invalidArgument("id or name");
        }
        Tenant tenant = new Tenant(id, name, selfProvisioningDomains);
        this.update(tenant);
    }

    private void update(Tenant tenant) {
        URI updateTenantUri = this.composeUpdateTenantUri();
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(updateTenantUri, tenant, Void.class);
    }

    @Override
    public void delete(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        URI deleteTenantUri = this.composeDeleteTenantUri();
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(deleteTenantUri, Map.of("id", id), Void.class);
    }

    @Override
    public List<Tenant> loadAll() throws DescopeException {
        URI loadAllTenantsUri = this.loadAllTenantsUri();
        ApiProxy apiProxy = this.getApiProxy();
        GetAllTenantsResponse response = apiProxy.get(loadAllTenantsUri, GetAllTenantsResponse.class);
        return response.getTenants();
    }

    private URI composeCreateTenantUri() {
        return this.getUri("/v1/mgmt/tenant/create");
    }

    private URI composeUpdateTenantUri() {
        return this.getUri("/v1/mgmt/tenant/update");
    }

    private URI composeDeleteTenantUri() {
        return this.getUri("/v1/mgmt/tenant/delete");
    }

    private URI loadAllTenantsUri() {
        return this.getUri("/v1/mgmt/tenant/all");
    }
}

