/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.tenant.Tenant;
import com.descope.model.tenant.TenantSettings;
import com.descope.model.tenant.request.TenantSearchRequest;
import com.descope.model.tenant.response.GetAllTenantsResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.TenantService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import com.descope.utils.CollectionUtils;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class TenantServiceImpl
extends ManagementsBase
implements TenantService {
    TenantServiceImpl(Client client) {
        super(client);
    }

    @Override
    public String create(String name, List<String> selfProvisioningDomains) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("name");
        }
        return this.create(Tenant.builder().name(name).selfProvisioningDomains(selfProvisioningDomains).build());
    }

    @Override
    public String create(String name, List<String> selfProvisioningDomains, Map<String, Object> customAttributes) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("name");
        }
        return this.create(Tenant.builder().name(name).selfProvisioningDomains(selfProvisioningDomains).customAttributes(customAttributes).build());
    }

    @Override
    public void createWithId(String id, String name, List<String> selfProvisioningDomains) throws DescopeException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{id, name})) {
            throw ServerCommonException.invalidArgument("id or name");
        }
        this.create(Tenant.builder().id(id).name(name).selfProvisioningDomains(selfProvisioningDomains).build());
    }

    @Override
    public void createWithId(String id, String name, List<String> selfProvisioningDomains, Map<String, Object> customAttributes) throws DescopeException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{id, name})) {
            throw ServerCommonException.invalidArgument("id or name");
        }
        this.create(Tenant.builder().id(id).name(name).selfProvisioningDomains(selfProvisioningDomains).customAttributes(customAttributes).build());
    }

    private String create(Tenant tenant) {
        URI createTenantUri = this.composeCreateTenantUri();
        ApiProxy apiProxy = this.getApiProxy();
        Tenant savedTenant = apiProxy.post(createTenantUri, tenant, Tenant.class);
        return savedTenant.getId();
    }

    @Override
    public void update(String id, String name, List<String> selfProvisioningDomains, Map<String, Object> customAttributes) throws DescopeException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{id, name})) {
            throw ServerCommonException.invalidArgument("id or name");
        }
        this.update(Tenant.builder().id(id).name(name).selfProvisioningDomains(selfProvisioningDomains).customAttributes(customAttributes).build());
    }

    private void update(Tenant tenant) {
        URI updateTenantUri = this.composeUpdateTenantUri();
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(updateTenantUri, tenant, Void.class);
    }

    @Override
    public void delete(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        URI deleteTenantUri = this.composeDeleteTenantUri();
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(deleteTenantUri, CollectionUtils.mapOf("id", id), Void.class);
    }

    @Override
    public Tenant load(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.loadTenantUri(id), Tenant.class);
    }

    @Override
    public List<Tenant> loadAll() throws DescopeException {
        URI loadAllTenantsUri = this.loadAllTenantsUri();
        ApiProxy apiProxy = this.getApiProxy();
        GetAllTenantsResponse response = apiProxy.get(loadAllTenantsUri, GetAllTenantsResponse.class);
        return response.getTenants();
    }

    @Override
    public List<Tenant> searchAll(TenantSearchRequest request) throws DescopeException {
        if (request == null) {
            request = TenantSearchRequest.builder().build();
        }
        URI composeSearchAllUri = this.composeSearchAllUri();
        ApiProxy apiProxy = this.getApiProxy();
        GetAllTenantsResponse response = apiProxy.post(composeSearchAllUri, request, GetAllTenantsResponse.class);
        return response.getTenants();
    }

    @Override
    public TenantSettings getSettings(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getSettingsUri(id), TenantSettings.class);
    }

    @Override
    public void configureSettings(String id, TenantSettings settings) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        if (settings == null) {
            throw ServerCommonException.invalidArgument("settings");
        }
        Map<String, Object> req = CollectionUtils.mapOf("tenantId", id);
        CollectionUtils.addIfNotNull(req, "selfProvisioningDomains", settings.getSelfProvisioningDomains());
        CollectionUtils.addIfNotNull(req, "enabled", settings.getSessionSettingsEnabled());
        CollectionUtils.addIfNotNull(req, "sessionTokenExpiration", settings.getSessionTokenExpiration());
        CollectionUtils.addIfNotNull(req, "refreshTokenExpiration", settings.getRefreshTokenExpiration());
        CollectionUtils.addIfNotNull(req, "sessionTokenExpirationUnit", settings.getSessionTokenExpirationUnit());
        CollectionUtils.addIfNotNull(req, "refreshTokenExpirationUnit", settings.getRefreshTokenExpirationUnit());
        CollectionUtils.addIfNotNull(req, "inactivityTime", settings.getInactivityTime());
        CollectionUtils.addIfNotNull(req, "inactivityTimeUnit", settings.getInactivityTimeUnit());
        CollectionUtils.addIfNotNull(req, "enableInactivity", settings.getEnableInactivity());
        CollectionUtils.addIfNotNull(req, "domains", settings.getDomains());
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.configureSettingsUri(), req, Void.class);
    }

    private URI composeCreateTenantUri() {
        return this.getUri("/v1/mgmt/tenant/create");
    }

    private URI composeUpdateTenantUri() {
        return this.getUri("/v1/mgmt/tenant/update");
    }

    private URI composeDeleteTenantUri() {
        return this.getUri("/v1/mgmt/tenant/delete");
    }

    private URI loadTenantUri(String id) {
        return this.getQueryParamUri("/v1/mgmt/tenant", CollectionUtils.mapOf("id", id));
    }

    private URI loadAllTenantsUri() {
        return this.getUri("/v1/mgmt/tenant/all");
    }

    private URI composeSearchAllUri() {
        return this.getUri("/v1/mgmt/tenant/search");
    }

    private URI getSettingsUri(String id) {
        return this.getQueryParamUri("/v1/mgmt/tenant/settings", CollectionUtils.mapOf("id", id));
    }

    private URI configureSettingsUri() {
        return this.getUri("/v1/mgmt/tenant/settings");
    }
}

