/*
 * Decompiled with CFR 0.152.
 */
package com.descope.proxy.impl;

import com.descope.exception.RateLimitExceededException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.SdkInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractProxyImpl {
    private static final Logger log = LoggerFactory.getLogger(AbstractProxyImpl.class);
    private String authHeaderKey;
    private Supplier<String> authHeaderSupplier;
    private SdkInfo sdkInfo;

    AbstractProxyImpl() {
    }

    private static <B> HttpRequest.BodyPublisher getBodyPublisher(B body) {
        if (body == null) {
            return HttpRequest.BodyPublishers.ofString("");
        }
        ObjectMapper objectMapper = new ObjectMapper();
        String requestBody = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(body);
        return HttpRequest.BodyPublishers.ofString(requestBody);
    }

    protected void setAuthHeader(String authHeaderKey, Supplier<String> authHeaderSupplier) {
        if (StringUtils.isNotBlank((CharSequence)authHeaderKey) && authHeaderSupplier != null) {
            this.authHeaderKey = authHeaderKey;
            this.authHeaderSupplier = authHeaderSupplier;
        } else if (StringUtils.isBlank((CharSequence)authHeaderKey)) {
            this.authHeaderKey = null;
            this.authHeaderSupplier = null;
        }
    }

    protected void setSdkInfo(SdkInfo sdkInfo) {
        this.sdkInfo = sdkInfo;
    }

    <B, R> R exchange(URI uri, String method, B body, Class<R> returnClz) {
        HttpRequest.Builder httpRequestBuilder = HttpRequest.newBuilder().uri(uri);
        this.addHeaders(httpRequestBuilder);
        HttpRequest httpRequest = "GET".equals(method) ? httpRequestBuilder.GET().build() : httpRequestBuilder.method(method, AbstractProxyImpl.getBodyPublisher(body)).build();
        HttpClient httpClient = HttpClient.newHttpClient();
        JsonBodyHandler<R> bodyHandler = new JsonBodyHandler<R>(returnClz);
        log.debug(String.format("Sending %s request to %s", method, uri.toString()));
        Supplier responseSupplier = (Supplier)httpClient.send(httpRequest, bodyHandler).body();
        return (R)responseSupplier.get();
    }

    private void addHeaders(HttpRequest.Builder httpRequestBuilder) {
        httpRequestBuilder.header("Content-Type", "application/json");
        if (StringUtils.isNotBlank((CharSequence)this.authHeaderKey)) {
            String authHeaderVal = this.authHeaderSupplier.get();
            httpRequestBuilder.header(this.authHeaderKey, authHeaderVal);
        }
        if (this.sdkInfo != null) {
            if (StringUtils.isNotBlank((CharSequence)this.sdkInfo.getJavaVersion())) {
                httpRequestBuilder.header("x-descope-sdk-java-version", this.sdkInfo.getJavaVersion());
            }
            if (StringUtils.isNotBlank((CharSequence)this.sdkInfo.getName())) {
                httpRequestBuilder.header("x-descope-sdk-name", this.sdkInfo.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)this.sdkInfo.getVersion())) {
                httpRequestBuilder.header("x-descope-sdk-version", this.sdkInfo.getVersion());
            }
            if (StringUtils.isNotBlank((CharSequence)this.sdkInfo.getSha())) {
                httpRequestBuilder.header("x-descope-sdk-sha", this.sdkInfo.getSha());
            }
        }
    }

    protected <B, R> R post(URI uri, B body, Class<R> returnClz) {
        return this.exchange(uri, "POST", body, returnClz);
    }

    protected <R> R get(URI uri, Class<R> returnClz) {
        return this.exchange(uri, "GET", null, returnClz);
    }

    protected <B, R> R delete(URI uri, B body, Class<R> returnClz) {
        return this.exchange(uri, "DELETE", body, returnClz);
    }

    private static class JsonBodyHandler<R>
    implements HttpResponse.BodyHandler<Supplier<R>> {
        private static final String RETRY_AFTER_HEADER = "Retry-After";
        private static final long DEFAULT_RETRY = 60L;
        private final Class<R> returnClz;

        public JsonBodyHandler(Class<R> returnClz) {
            this.returnClz = returnClz;
        }

        private static <R> HttpResponse.BodySubscriber<Supplier<R>> asJson(HttpResponse.ResponseInfo responseInfo, Class<R> returnClz) {
            HttpResponse.BodySubscriber<InputStream> upstream = HttpResponse.BodySubscribers.ofInputStream();
            return HttpResponse.BodySubscribers.mapping(upstream, inputStream -> JsonBodyHandler.toSupplierOfType(inputStream, responseInfo, returnClz));
        }

        private static <R> Supplier<R> toSupplierOfType(InputStream inputStream, HttpResponse.ResponseInfo responseInfo, Class<R> returnClz) {
            return () -> {
                Object object;
                block10: {
                    InputStream stream = inputStream;
                    try {
                        ObjectMapper objectMapper = new ObjectMapper();
                        if (responseInfo.statusCode() < 200 || responseInfo.statusCode() > 299) {
                            ErrorDetails errorDetails = (ErrorDetails)objectMapper.readValue(stream, ErrorDetails.class);
                            log.error(errorDetails.getActualMessage());
                            if ("E130429".equals(errorDetails.errorCode)) {
                                throw new RateLimitExceededException(errorDetails.getActualMessage(), errorDetails.getErrorCode(), responseInfo.headers().firstValueAsLong(RETRY_AFTER_HEADER).orElse(60L));
                            }
                            throw ServerCommonException.genericServerError(errorDetails.getActualMessage(), errorDetails.getErrorCode());
                        }
                        object = objectMapper.readValue(stream, returnClz);
                        if (stream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    stream.close();
                }
                return object;
            };
        }

        @Override
        public HttpResponse.BodySubscriber<Supplier<R>> apply(HttpResponse.ResponseInfo responseInfo) {
            return JsonBodyHandler.asJson(responseInfo, this.returnClz);
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        static class ErrorDetails {
            private String errorCode;
            private String errorDescription;
            private String errorMessage;
            private String message;

            String getActualMessage() {
                return this.errorMessage == null ? this.message : this.errorMessage;
            }

            public String getErrorCode() {
                return this.errorCode;
            }

            public String getErrorDescription() {
                return this.errorDescription;
            }

            public String getErrorMessage() {
                return this.errorMessage;
            }

            public String getMessage() {
                return this.message;
            }

            public void setErrorCode(String errorCode) {
                this.errorCode = errorCode;
            }

            public void setErrorDescription(String errorDescription) {
                this.errorDescription = errorDescription;
            }

            public void setErrorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
            }

            public void setMessage(String message) {
                this.message = message;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ErrorDetails)) {
                    return false;
                }
                ErrorDetails other = (ErrorDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$errorCode = this.getErrorCode();
                String other$errorCode = other.getErrorCode();
                if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
                    return false;
                }
                String this$errorDescription = this.getErrorDescription();
                String other$errorDescription = other.getErrorDescription();
                if (this$errorDescription == null ? other$errorDescription != null : !this$errorDescription.equals(other$errorDescription)) {
                    return false;
                }
                String this$errorMessage = this.getErrorMessage();
                String other$errorMessage = other.getErrorMessage();
                if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                return !(this$message == null ? other$message != null : !this$message.equals(other$message));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ErrorDetails;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $errorCode = this.getErrorCode();
                result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
                String $errorDescription = this.getErrorDescription();
                result = result * 59 + ($errorDescription == null ? 43 : $errorDescription.hashCode());
                String $errorMessage = this.getErrorMessage();
                result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                return result;
            }

            public String toString() {
                return "AbstractProxyImpl.JsonBodyHandler.ErrorDetails(errorCode=" + this.getErrorCode() + ", errorDescription=" + this.getErrorDescription() + ", errorMessage=" + this.getErrorMessage() + ", message=" + this.getMessage() + ")";
            }

            public ErrorDetails() {
            }

            public ErrorDetails(String errorCode, String errorDescription, String errorMessage, String message) {
                this.errorCode = errorCode;
                this.errorDescription = errorDescription;
                this.errorMessage = errorMessage;
                this.message = message;
            }
        }
    }
}

