/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.enums.DeliveryMethod;
import com.descope.exception.ServerCommonException;
import com.descope.model.auth.AuthParams;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.client.Client;
import com.descope.model.jwt.Token;
import com.descope.model.jwt.response.JWTResponse;
import com.descope.model.magiclink.Tokens;
import com.descope.model.magiclink.response.Masked;
import com.descope.model.magiclink.response.MaskedEmailRes;
import com.descope.model.magiclink.response.MaskedPhoneRes;
import com.descope.model.user.User;
import com.descope.proxy.ApiProxy;
import com.descope.proxy.impl.ApiProxyBuilder;
import com.descope.sdk.SdkServicesBase;
import com.descope.sdk.auth.AuthenticationService;
import com.descope.utils.JwtUtils;
import com.descope.utils.PatternUtils;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AuthenticationsBase
extends SdkServicesBase
implements AuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationsBase.class);
    private final AuthParams authParams;

    AuthenticationsBase(Client client, AuthParams authParams) {
        super(client, authParams.getProjectId());
        this.authParams = authParams;
    }

    ApiProxy getApiProxy() {
        String projectId = this.authParams.getProjectId();
        if (StringUtils.isNotBlank((CharSequence)projectId)) {
            return ApiProxyBuilder.buildProxy(() -> "Bearer " + projectId, this.client.getSdkInfo());
        }
        return ApiProxyBuilder.buildProxy(this.client.getSdkInfo());
    }

    ApiProxy getApiProxy(String refreshToken) {
        String projectId = this.authParams.getProjectId();
        if (StringUtils.isBlank((CharSequence)refreshToken) || StringUtils.isBlank((CharSequence)projectId)) {
            return this.getApiProxy();
        }
        String token = String.format("Bearer %s:%s", projectId, refreshToken);
        return ApiProxyBuilder.buildProxy(() -> token, this.client.getSdkInfo());
    }

    void verifyDeliveryMethod(DeliveryMethod deliveryMethod, String loginId, User user) {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        switch (deliveryMethod) {
            case SMS: 
            case WHATSAPP: {
                String phone = user.getPhone();
                if (StringUtils.isBlank((CharSequence)phone)) {
                    phone = loginId;
                }
                if (PatternUtils.PHONE_PATTERN.matcher(phone).matches()) break;
                throw ServerCommonException.invalidArgument("user.phone");
            }
            case EMAIL: {
                String email = user.getEmail();
                if (StringUtils.isBlank((CharSequence)email)) {
                    email = loginId;
                    user.setEmail(email);
                }
                if (PatternUtils.EMAIL_PATTERN.matcher(email).matches()) break;
                throw ServerCommonException.invalidArgument("user.email");
            }
            default: {
                throw ServerCommonException.invalidArgument("DeliveryMethod");
            }
        }
    }

    Class<? extends Masked> getMaskedValue(DeliveryMethod deliveryMethod) {
        switch (deliveryMethod) {
            case SMS: 
            case WHATSAPP: {
                return MaskedPhoneRes.class;
            }
            case EMAIL: {
                return MaskedEmailRes.class;
            }
        }
        throw new IllegalStateException("Unexpected value: " + deliveryMethod);
    }

    String getValidRefreshToken(HttpRequest request) {
        Tokens tokens = this.provideTokens(request);
        if (StringUtils.isEmpty((CharSequence)tokens.getRefreshToken())) {
            throw ServerCommonException.refreshToken("Unable to find tokens from cookies");
        }
        return tokens.getRefreshToken();
    }

    Tokens provideTokens(HttpRequest request) {
        Optional<String> cookies;
        if (request == null) {
            return Tokens.builder().build();
        }
        Tokens tokens = new Tokens();
        Optional<String> authToken = request.headers().firstValue("Authorization");
        if (authToken.isPresent()) {
            try {
                String sessionToken = this.getSessionTokenFromBearerToken(authToken.get());
                tokens.setSessionToken(sessionToken);
            }
            catch (ServerCommonException e) {
                log.warn(e.getMessage());
            }
        }
        if (StringUtils.isEmpty((CharSequence)tokens.getSessionToken()) && (cookies = request.headers().firstValue("Cookie")).isPresent()) {
            String refreshCookie;
            String[] cookiesList = cookies.get().split(";");
            String sessionCookie = Arrays.stream(cookiesList).filter(cookie -> cookie.contains("DS")).map(String::trim).findAny().orElse(null);
            if (sessionCookie != null) {
                tokens.setSessionToken(sessionCookie.split("=")[1]);
            }
            if ((refreshCookie = (String)Arrays.stream(cookiesList).filter(cookie -> cookie.contains("DSR")).findAny().orElse(null)) != null) {
                tokens.setRefreshToken(refreshCookie.split("=")[1]);
            }
        }
        return tokens;
    }

    String getSessionTokenFromBearerToken(String bearerToken) {
        String[] sessionTokens;
        if (StringUtils.isNotBlank((CharSequence)bearerToken) && (sessionTokens = bearerToken.split("Bearer ")).length == 2) {
            try {
                return sessionTokens[1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw ServerCommonException.invalidArgument("bearerToken");
            }
        }
        throw ServerCommonException.invalidArgument("bearerToken");
    }

    Token validateJWT(String jwt) {
        return JwtUtils.getToken(jwt, this.requestKeys());
    }

    Token refreshSession(String refreshToken) {
        this.validateJWT(refreshToken);
        ApiProxy apiProxy = this.getApiProxy(refreshToken);
        URI refreshTokenLinkURL = this.composeRefreshTokenLinkURL();
        JWTResponse jwtResponse = apiProxy.post(refreshTokenLinkURL, null, JWTResponse.class);
        AuthenticationInfo authenticationInfo = this.getAuthenticationInfo(jwtResponse);
        return authenticationInfo.getToken();
    }

    AuthenticationInfo getAuthenticationInfo(JWTResponse jwtResponse) {
        Token sessionToken = this.validateAndCreateToken(jwtResponse.getSessionJwt());
        Token refreshToken = null;
        if (StringUtils.isNotBlank((CharSequence)jwtResponse.getRefreshJwt())) {
            refreshToken = this.validateAndCreateToken(jwtResponse.getRefreshJwt());
        }
        return new AuthenticationInfo(sessionToken, refreshToken, jwtResponse.getUser(), jwtResponse.getFirstSeen());
    }

    List<String> getAuthorizationClaimItems(Token token, String tenant, List<String> permissions) {
        if (tenant == null || MapUtils.isEmpty(token.getClaims())) {
            return Collections.emptyList();
        }
        return token.getClaims().keySet().stream().filter(permissions::contains).collect(Collectors.toList());
    }

    private URI composeRefreshTokenLinkURL() {
        return this.getUri("/v1/auth/refresh");
    }
}

