/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.enums.DeliveryMethod;
import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.auth.AuthParams;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.client.Client;
import com.descope.model.jwt.response.JWTResponse;
import com.descope.model.magiclink.LoginOptions;
import com.descope.model.magiclink.response.Masked;
import com.descope.model.otp.AuthenticationVerifyRequestBody;
import com.descope.model.otp.SignInRequest;
import com.descope.model.otp.SignUpRequest;
import com.descope.model.otp.UpdateEmailRequestBody;
import com.descope.model.otp.UpdatePhoneRequestBody;
import com.descope.model.user.User;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.auth.OTPService;
import com.descope.sdk.auth.impl.AuthenticationServiceImpl;
import com.descope.utils.JwtUtils;
import com.descope.utils.PatternUtils;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

class OTPServiceImpl
extends AuthenticationServiceImpl
implements OTPService {
    OTPServiceImpl(Client client, AuthParams authParams) {
        super(client, authParams);
    }

    @Override
    public String signIn(DeliveryMethod deliveryMethod, String loginId, LoginOptions loginOptions) throws DescopeException {
        ApiProxy apiProxy;
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        Class<? extends Masked> maskedClass = this.getMaskedValue(deliveryMethod);
        URI otpSignInURL = this.composeSignInURL(deliveryMethod);
        SignInRequest signInRequest = new SignInRequest(loginId, loginOptions);
        if (JwtUtils.isJWTRequired(loginOptions)) {
            String pwd = "";
            apiProxy = this.getApiProxy(pwd);
        } else {
            apiProxy = this.getApiProxy();
        }
        Masked masked = apiProxy.post(otpSignInURL, signInRequest, maskedClass);
        return masked.getMasked();
    }

    @Override
    public String signUp(DeliveryMethod deliveryMethod, String loginId, User user) throws DescopeException {
        if (user == null) {
            user = new User();
        }
        this.verifyDeliveryMethod(deliveryMethod, loginId, user);
        Class<? extends Masked> maskedClass = this.getMaskedValue(deliveryMethod);
        URI otpSignUpURL = this.composeSignUpURI(deliveryMethod);
        SignUpRequest signUpRequest = this.newSignUpRequest(deliveryMethod, user);
        signUpRequest.setLoginId(loginId);
        signUpRequest.setUser(user);
        ApiProxy apiProxy = this.getApiProxy();
        Masked masked = apiProxy.post(otpSignUpURL, signUpRequest, maskedClass);
        return masked.getMasked();
    }

    @Override
    public String signUpOrIn(DeliveryMethod deliveryMethod, String loginId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        Class<? extends Masked> maskedClass = this.getMaskedValue(deliveryMethod);
        URI otpSignUpOrInURL = this.composeSignUpOrInURL(deliveryMethod);
        SignInRequest signInRequest = new SignInRequest(loginId, null);
        ApiProxy apiProxy = this.getApiProxy();
        Masked masked = apiProxy.post(otpSignUpOrInURL, signInRequest, maskedClass);
        return masked.getMasked();
    }

    @Override
    public AuthenticationInfo verifyCode(DeliveryMethod deliveryMethod, String loginId, String code) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (PatternUtils.PHONE_PATTERN.matcher(loginId).matches()) {
            deliveryMethod = DeliveryMethod.SMS;
        } else if (PatternUtils.EMAIL_PATTERN.matcher(loginId).matches()) {
            deliveryMethod = DeliveryMethod.EMAIL;
        }
        if (deliveryMethod == null) {
            throw ServerCommonException.invalidArgument("Method");
        }
        AuthenticationVerifyRequestBody authenticationVerifyRequestBody = new AuthenticationVerifyRequestBody(loginId, code);
        URI otpVerifyCode = this.composeVerifyCodeURL(deliveryMethod);
        ApiProxy apiProxy = this.getApiProxy();
        JWTResponse jwtResponse = apiProxy.post(otpVerifyCode, authenticationVerifyRequestBody, JWTResponse.class);
        return this.getAuthenticationInfo(jwtResponse);
    }

    @Override
    public String updateUserEmail(String loginId, String email) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (StringUtils.isBlank((CharSequence)email) || !PatternUtils.EMAIL_PATTERN.matcher(email).matches()) {
            throw ServerCommonException.invalidArgument("Email");
        }
        Class<? extends Masked> maskedClass = this.getMaskedValue(DeliveryMethod.EMAIL);
        URI otpUpdateUserEmail = this.composeUpdateUserEmailOTP();
        UpdateEmailRequestBody updateEmailRequest = new UpdateEmailRequestBody(email, loginId);
        ApiProxy apiProxy = this.getApiProxy();
        Masked masked = apiProxy.post(otpUpdateUserEmail, updateEmailRequest, maskedClass);
        return masked.getMasked();
    }

    @Override
    public String updateUserPhone(DeliveryMethod deliveryMethod, String loginId, String phone) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (StringUtils.isBlank((CharSequence)phone) || !PatternUtils.PHONE_PATTERN.matcher(phone).matches()) {
            throw ServerCommonException.invalidArgument("Phone");
        }
        if (deliveryMethod != DeliveryMethod.WHATSAPP && deliveryMethod != DeliveryMethod.SMS) {
            throw ServerCommonException.invalidArgument("Method");
        }
        Class<? extends Masked> maskedClass = this.getMaskedValue(DeliveryMethod.SMS);
        URI otpUpdateUserPhone = this.composeUpdateUserPhoneOTP(deliveryMethod);
        UpdatePhoneRequestBody updatePhoneRequestBody = new UpdatePhoneRequestBody(phone, loginId);
        ApiProxy apiProxy = this.getApiProxy();
        Masked masked = apiProxy.post(otpUpdateUserPhone, updatePhoneRequestBody, maskedClass);
        return masked.getMasked();
    }

    private URI composeUpdateUserPhoneOTP(DeliveryMethod deliveryMethod) {
        return this.composeURI("/v1/auth/otp/update/phone", deliveryMethod.getValue());
    }

    private URI composeUpdateUserEmailOTP() {
        return this.getUri("/v1/auth/otp/update/email");
    }

    private URI composeVerifyCodeURL(DeliveryMethod deliveryMethod) {
        return this.composeURI("/v1/auth/otp/verify", deliveryMethod.getValue());
    }

    private URI composeSignUpOrInURL(DeliveryMethod deliveryMethod) {
        return this.composeURI("/v1/auth/otp/signup-in", deliveryMethod.getValue());
    }

    private SignUpRequest newSignUpRequest(DeliveryMethod deliveryMethod, User user) {
        if (DeliveryMethod.SMS.equals((Object)deliveryMethod)) {
            return SignUpRequest.builder().phone(user.getPhone()).build();
        }
        if (DeliveryMethod.WHATSAPP.equals((Object)deliveryMethod)) {
            return SignUpRequest.builder().whatsApp(user.getPhone()).build();
        }
        return SignUpRequest.builder().email(user.getEmail()).build();
    }

    private URI composeSignUpURI(DeliveryMethod deliveryMethod) {
        return this.composeURI("/v1/auth/otp/signup", deliveryMethod.getValue());
    }

    private URI composeSignInURL(DeliveryMethod deliveryMethod) {
        return this.composeURI("/v1/auth/otp/signin", deliveryMethod.getValue());
    }
}

