/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.auth.AssociatedTenant;
import com.descope.model.client.Client;
import com.descope.model.mgmt.AccessKeyRequest;
import com.descope.model.mgmt.AccessKeyResponse;
import com.descope.model.mgmt.AccessKeyResponseList;
import com.descope.model.mgmt.ManagementParams;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.AccessKeyService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import com.descope.utils.MgmtUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class AccessKeyServiceImpl
extends ManagementsBase
implements AccessKeyService {
    AccessKeyServiceImpl(Client client, ManagementParams managementParams) {
        super(client, managementParams);
    }

    @Override
    public AccessKeyResponse create(String name, int expireTime, List<String> roleNames, List<AssociatedTenant> keyTenants) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("Name");
        }
        AccessKeyRequest body = this.createAccessKeyBody(name, expireTime, roleNames, keyTenants);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/accesskey/create"), body, AccessKeyResponse.class);
    }

    @Override
    public AccessKeyResponse load(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("Id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getQueryParamUri("/v1/mgmt/accesskey", Map.of("id", id)), AccessKeyResponse.class);
    }

    @Override
    public AccessKeyResponseList searchAll(List<String> tenantIDs) throws DescopeException {
        Map<Object, Object> request = tenantIDs == null ? new HashMap() : Map.of("tenantIds", tenantIDs);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/accesskey/search"), request, AccessKeyResponseList.class);
    }

    @Override
    public AccessKeyResponse update(String id, String name) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("Id");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("Name");
        }
        Map<String, String> request = Map.of("id", id, "name", name);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/accesskey/update"), request, AccessKeyResponse.class);
    }

    @Override
    public AccessKeyResponse deactivate(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("Id");
        }
        Map<String, String> request = Map.of("id", id);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/accesskey/deactivate"), request, AccessKeyResponse.class);
    }

    @Override
    public AccessKeyResponse activate(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("Id");
        }
        Map<String, String> request = Map.of("id", id);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/accesskey/activate"), request, AccessKeyResponse.class);
    }

    @Override
    public void delete(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("Id");
        }
        Map<String, String> request = Map.of("id", id);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/accesskey/delete"), request, Void.class);
    }

    private AccessKeyRequest createAccessKeyBody(String name, int expireTime, List<String> roleNames, List<AssociatedTenant> keyTenants) {
        return AccessKeyRequest.builder().name(name).expireTime(expireTime).roleNames(roleNames).keyTenants(MgmtUtils.createAssociatedTenantList(keyTenants)).build();
    }
}

