/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.mgmt.ManagementParams;
import com.descope.model.sso.AttributeMapping;
import com.descope.model.sso.RoleMapping;
import com.descope.model.sso.SSOSettingsResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.SsoService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class SsoServiceImpl
extends ManagementsBase
implements SsoService {
    SsoServiceImpl(Client client, ManagementParams managementParams) {
        super(client, managementParams);
    }

    @Override
    public SSOSettingsResponse getSettings(String tenantID) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw ServerCommonException.invalidArgument("TenantId");
        }
        Map<String, String> params = Map.of("tenantId", tenantID);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getQueryParamUri("/mgmt/sso/settings", params), SSOSettingsResponse.class);
    }

    @Override
    public void deleteSettings(String tenantID) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw ServerCommonException.invalidArgument("TenantId");
        }
        Map<String, String> request = Map.of("tenantId", tenantID);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.delete(this.getUri("/mgmt/sso/settings"), request, Void.class);
    }

    @Override
    public void configureSettings(String tenantID, String idpURL, String idpCert, String entityID, String redirectURL, String domain) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw ServerCommonException.invalidArgument("TenantID");
        }
        if (StringUtils.isBlank((CharSequence)idpURL)) {
            throw ServerCommonException.invalidArgument("IdpURL");
        }
        if (StringUtils.isBlank((CharSequence)idpCert)) {
            throw ServerCommonException.invalidArgument("IdpCert");
        }
        if (StringUtils.isBlank((CharSequence)entityID)) {
            throw ServerCommonException.invalidArgument("EntityID");
        }
        if (StringUtils.isBlank((CharSequence)redirectURL)) {
            throw ServerCommonException.invalidArgument("RedirectURL");
        }
        Map<String, String> request = Map.of("tenantId", tenantID, "idpURL", idpURL, "idpCert", idpCert, "entityId", entityID, "redirectURL", redirectURL, "domain", domain);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/mgmt/sso/settings"), request, Void.class);
    }

    @Override
    public void configureMetadata(String tenantID, String idpMetadataURL) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw ServerCommonException.invalidArgument("TenantID");
        }
        if (StringUtils.isBlank((CharSequence)idpMetadataURL)) {
            throw ServerCommonException.invalidArgument("IdpMetadataURL");
        }
        Map<String, String> request = Map.of("tenantId", tenantID, "idpMetadataURL", idpMetadataURL);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/mgmt/sso/metadata"), request, Void.class);
    }

    @Override
    public void configureMapping(String tenantID, List<RoleMapping> roleMapping, AttributeMapping attributeMapping) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw ServerCommonException.invalidArgument("TenantID");
        }
        Map<String, AttributeMapping> request = Map.of("tenantId", tenantID, "roleMappings", roleMapping, "attributeMapping", attributeMapping);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/mgmt/sso/mapping"), request, Void.class);
    }
}

