/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.enums.DeliveryMethod;
import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.mgmt.ManagementParams;
import com.descope.model.user.request.EnchantedLinkTestUserRequest;
import com.descope.model.user.request.MagicLinkTestUserRequest;
import com.descope.model.user.request.OTPTestUserRequest;
import com.descope.model.user.request.UserRequest;
import com.descope.model.user.request.UserSearchRequest;
import com.descope.model.user.response.AllUsersResponseDetails;
import com.descope.model.user.response.EnchantedLinkTestUserResponse;
import com.descope.model.user.response.MagicLinkTestUserResponse;
import com.descope.model.user.response.OTPTestUserResponse;
import com.descope.model.user.response.UserResponseDetails;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.UserService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class UserServiceImpl
extends ManagementsBase
implements UserService {
    UserServiceImpl(Client client, ManagementParams managementParams) {
        super(client, managementParams);
    }

    @Override
    public UserResponseDetails create(String loginId, UserRequest request) throws DescopeException {
        if (request == null) {
            request = new UserRequest();
        }
        request.setLoginId(loginId);
        request.setInvite(false);
        request.setTest(false);
        URI createUserUri = this.composeCreateUserUri();
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(createUserUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails createTestUser(String loginId, UserRequest request) throws DescopeException {
        if (request == null) {
            request = new UserRequest();
        }
        request.setLoginId(loginId);
        request.setInvite(false);
        request.setTest(true);
        URI createUserUri = this.composeCreateUserUri();
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(createUserUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails invite(String loginId, UserRequest request) throws DescopeException {
        if (request == null) {
            request = new UserRequest();
        }
        request.setLoginId(loginId);
        request.setInvite(true);
        request.setTest(false);
        URI createUserUri = this.composeCreateUserUri();
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(createUserUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails update(String loginId, UserRequest request) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (request == null) {
            request = new UserRequest();
        }
        request.setLoginId(loginId);
        URI updateUserUri = this.composeUpdateUserUri();
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(updateUserUri, request, UserResponseDetails.class);
    }

    @Override
    public void delete(String loginId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI deleteUserUri = this.composeDeleteUserUri();
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(deleteUserUri, UserRequest.builder().loginId(loginId).build(), Void.class);
    }

    @Override
    public void deleteAllTestUsers() throws DescopeException {
        URI deleteAllTestUsersUri = this.composeDeleteAllTestUsersUri();
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.delete(deleteAllTestUsersUri, null, Void.class);
    }

    @Override
    public UserResponseDetails load(String loginId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI loadUserUri = this.composeLoadUserUri(Map.of("loginId", loginId));
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(loadUserUri, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails loadByUserId(String userId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw ServerCommonException.invalidArgument("User ID");
        }
        URI loadUserUri = this.composeLoadUserUri(Map.of("userId", userId));
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(loadUserUri, UserResponseDetails.class);
    }

    @Override
    public AllUsersResponseDetails searchAll(UserSearchRequest request) throws DescopeException {
        if (request == null) {
            request = UserSearchRequest.builder().limit(0).page(0).build();
        }
        if (request.getLimit() == null || request.getLimit() < 0) {
            throw ServerCommonException.invalidArgument("limit");
        }
        if (request.getPage() == null || request.getPage() < 0) {
            throw ServerCommonException.invalidArgument("page");
        }
        URI composeSearchAllUri = this.composeSearchAllUri();
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(composeSearchAllUri, request, AllUsersResponseDetails.class);
    }

    @Override
    public UserResponseDetails activate(String loginId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI activateUserUri = this.composeActivateUserUri();
        Map<String, String> request = Map.of("loginId", loginId, "status", "enabled");
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(activateUserUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails deactivate(String loginId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI activateUserUri = this.composeActivateUserUri();
        Map<String, String> request = Map.of("loginId", loginId, "status", "disabled");
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(activateUserUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails updateEmail(String loginId, String email, Boolean isVerified) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI updateEmailUri = this.composeUpdateEmailUri();
        Map<String, Boolean> request = Map.of("loginId", loginId, "email", email, "verified", isVerified);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(updateEmailUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails updatePhone(String loginId, String phone, Boolean isVerified) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI updatePhoneUri = this.composeUpdatePhoneUri();
        Map<String, Boolean> request = Map.of("loginId", loginId, "phone", phone, "verified", isVerified);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(updatePhoneUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails updateDisplayName(String loginId, String displayName) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI updateUserNameUri = this.composeUpdateUserNameUri();
        Map<String, String> request = Map.of("loginId", loginId, "displayName", displayName);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(updateUserNameUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails updatePicture(String loginId, String picture) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI updatePictureUri = this.composeUpdatePictureUri();
        Map<String, String> request = Map.of("loginId", loginId, "picture", picture);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(updatePictureUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails updateCustomAttributes(String loginId, String key, Object value) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            throw ServerCommonException.invalidArgument("Key");
        }
        URI updateAttributesUri = this.composeUpdateAttributesUri();
        Map<String, Object> request = Map.of("loginId", loginId, "attributeKey", key, "attributeValue", value);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(updateAttributesUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails addRoles(String loginId, List<String> roles) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI addRolesUri = this.composeAddRolesUri();
        Map<String, List<String>> request = Map.of("loginId", loginId, "tenantId", "", "roleNames", roles);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(addRolesUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails removeRoles(String loginId, List<String> roles) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI removeRolesUri = this.composeRemoveRolesUri();
        Map<String, List<String>> request = Map.of("loginId", loginId, "tenantId", "", "roleNames", roles);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(removeRolesUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails addTenant(String loginId, String tenantId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI addTenantUri = this.composeAddTenantUri();
        Map<String, String> request = Map.of("loginId", loginId, "tenantId", tenantId);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(addTenantUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails removeTenant(String loginId, String tenantId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI removeTenantUri = this.composeRemoveTenantUri();
        Map<String, String> request = Map.of("loginId", loginId, "tenantId", tenantId);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(removeTenantUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails addTenantRoles(String loginId, String tenantId, List<String> roles) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI addTenantRolesUri = this.composeAddTenantRolesUri();
        Map<String, List<String>> request = Map.of("loginId", loginId, "tenantId", "", "roleNames", roles);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(addTenantRolesUri, request, UserResponseDetails.class);
    }

    @Override
    public UserResponseDetails removeTenantRoles(String loginId, String tenantId, List<String> roles) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI removeTenantRolesUri = this.composeRemoveTenantRolesUri();
        Map<String, List<String>> request = Map.of("loginId", loginId, "tenantId", "", "roleNames", roles);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(removeTenantRolesUri, request, UserResponseDetails.class);
    }

    @Override
    public void setPassword(String loginId, String password) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            throw ServerCommonException.invalidArgument("Password");
        }
        URI setPasswordUri = this.composeSetPasswordUri();
        Map<String, String> request = Map.of("loginId", loginId, "password", password);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(setPasswordUri, request, Void.class);
    }

    @Override
    public void expirePassword(String loginId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI expirePasswordUri = this.composeExpirePasswordUri();
        Map<String, String> request = Map.of("loginId", loginId);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(expirePasswordUri, request, Void.class);
    }

    @Override
    public OTPTestUserResponse generateOtpForTestUser(String loginId, DeliveryMethod deliveryMethod) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI otpForTestUserUri = this.composeOTPForTestUserUri();
        OTPTestUserRequest request = new OTPTestUserRequest(loginId, deliveryMethod.getValue());
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(otpForTestUserUri, request, OTPTestUserResponse.class);
    }

    @Override
    public MagicLinkTestUserResponse generateMagicLinkForTestUser(String loginId, String uri, DeliveryMethod deliveryMethod) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI maginLinkForTestUserUri = this.composeMaginLinkForTestUserUri();
        MagicLinkTestUserRequest request = new MagicLinkTestUserRequest(loginId, deliveryMethod.getValue(), uri);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(maginLinkForTestUserUri, request, MagicLinkTestUserResponse.class);
    }

    @Override
    public EnchantedLinkTestUserResponse generateEnchantedLinkForTestUser(String loginId, String uri) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        URI enchantedLinkForTestUserUri = this.composeEnchantedLinkForTestUserUri();
        EnchantedLinkTestUserRequest request = new EnchantedLinkTestUserRequest(loginId, uri);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(enchantedLinkForTestUserUri, request, EnchantedLinkTestUserResponse.class);
    }

    private URI composeCreateUserUri() {
        return this.getUri("/v1/mgmt/user/create");
    }

    private URI composeUpdateUserUri() {
        return this.getUri("/v1/mgmt/user/update");
    }

    private URI composeDeleteUserUri() {
        return this.getUri("/v1/mgmt/user/delete");
    }

    private URI composeDeleteAllTestUsersUri() {
        return this.getUri("/v1/mgmt/user/test/delete/all");
    }

    private URI composeLoadUserUri(Map<String, String> params) {
        return this.getQueryParamUri("/v1/mgmt/user", params);
    }

    private URI composeSearchAllUri() {
        return this.getUri("/v1/mgmt/user/search");
    }

    private URI composeActivateUserUri() {
        return this.getUri("/v1/mgmt/user/update/status");
    }

    private URI composeUpdateEmailUri() {
        return this.getUri("/v1/mgmt/user/update/email");
    }

    private URI composeUpdatePhoneUri() {
        return this.getUri("/v1/mgmt/user/update/phone");
    }

    private URI composeUpdateUserNameUri() {
        return this.getUri("/v1/mgmt/user/update/name");
    }

    private URI composeUpdateAttributesUri() {
        return this.getUri("/v1/mgmt/user/update/customAttribute");
    }

    private URI composeUpdatePictureUri() {
        return this.getUri("/v1/mgmt/user/update/picture");
    }

    private URI composeAddRolesUri() {
        return this.getUri("/v1/mgmt/user/update/role/add");
    }

    private URI composeRemoveRolesUri() {
        return this.getUri("/v1/mgmt/user/update/role/remove");
    }

    private URI composeAddTenantUri() {
        return this.getUri("/v1/mgmt/user/update/tenant/add");
    }

    private URI composeRemoveTenantUri() {
        return this.getUri("/v1/mgmt/user/update/tenant/remove");
    }

    private URI composeAddTenantRolesUri() {
        return this.getUri("/v1/mgmt/user/update/role/add");
    }

    private URI composeRemoveTenantRolesUri() {
        return this.getUri("/v1/mgmt/user/update/tenant/remove");
    }

    private URI composeOTPForTestUserUri() {
        return this.getUri("/v1/mgmt/tests/generate/otp");
    }

    private URI composeMaginLinkForTestUserUri() {
        return this.getUri("/v1/mgmt/tests/generate/magiclink");
    }

    private URI composeEnchantedLinkForTestUserUri() {
        return this.getUri("/v1/mgmt/tests/generate/enchantedlink");
    }

    private URI composeSetPasswordUri() {
        return this.getUri("/v1/mgmt/user/password/set");
    }

    private URI composeExpirePasswordUri() {
        return this.getUri("/v1/mgmt/user/password/expire");
    }
}

