/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.group.Group;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.GroupService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import com.descope.utils.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class GroupServiceImpl
extends ManagementsBase
implements GroupService {
    GroupServiceImpl(Client client) {
        super(client);
    }

    @Override
    public List<Group> loadAllGroups(String tenantID) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw ServerCommonException.invalidArgument("TenantId");
        }
        Map<String, String> request = CollectionUtils.mapOf("tenantId", tenantID);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/group/all"), request, List.class);
    }

    @Override
    public List<Group> loadAllGroupsForMembers(String tenantID, List<String> userIDs, List<String> loginIDs) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw ServerCommonException.invalidArgument("TenantId");
        }
        if (userIDs.isEmpty() && loginIDs.isEmpty()) {
            throw ServerCommonException.invalidArgument("userIDs and loginIDs");
        }
        Map<String, List<String>> request = CollectionUtils.mapOf("tenantId", tenantID, "loginIds", loginIDs, "userIds", userIDs);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/group/member/all"), request, List.class);
    }

    @Override
    public List<Group> loadAllGroupMembers(String tenantID, String groupID) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw ServerCommonException.invalidArgument("TenantId");
        }
        if (StringUtils.isBlank((CharSequence)groupID)) {
            throw ServerCommonException.invalidArgument("GroupID");
        }
        Map<String, String> request = CollectionUtils.mapOf("tenantId", tenantID, "groupId", groupID);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/group/members"), request, List.class);
    }
}

