/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.model.client.Client;
import com.descope.proxy.ApiProxy;
import com.descope.proxy.impl.ApiProxyBuilder;
import com.descope.sdk.SdkServicesBase;
import com.descope.sdk.mgmt.ManagementService;
import org.apache.commons.lang3.StringUtils;

abstract class ManagementsBase
extends SdkServicesBase
implements ManagementService {
    ManagementsBase(Client client) {
        super(client);
    }

    ApiProxy getApiProxy() {
        String projectId = this.client.getProjectId();
        String managementKey = this.client.getManagementKey();
        if (StringUtils.isNotBlank((CharSequence)projectId)) {
            return ApiProxyBuilder.buildProxy(() -> String.format("Bearer %s:%s", projectId, managementKey), this.client.getSdkInfo());
        }
        return ApiProxyBuilder.buildProxy(this.client.getSdkInfo());
    }

    ApiProxy getApiProxy(String refreshToken) {
        String projectId = this.client.getProjectId();
        if (StringUtils.isBlank((CharSequence)refreshToken) || StringUtils.isNotBlank((CharSequence)projectId)) {
            return this.getApiProxy();
        }
        String token = String.format("Bearer %s:%s", projectId, refreshToken);
        return ApiProxyBuilder.buildProxy(() -> token, this.client.getSdkInfo());
    }
}

