/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.auth.AccessKeyLoginOptions;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.auth.ExchangeTokenRequest;
import com.descope.model.client.Client;
import com.descope.model.jwt.Token;
import com.descope.model.jwt.response.JWTResponse;
import com.descope.model.user.response.UserHistoryResponse;
import com.descope.model.user.response.UserResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.auth.impl.AuthenticationsBase;
import com.descope.utils.CollectionUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class AuthenticationServiceImpl
extends AuthenticationsBase {
    AuthenticationServiceImpl(Client client) {
        super(client);
    }

    @Override
    public Token validateSessionWithToken(String sessionToken) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)sessionToken)) {
            throw ServerCommonException.invalidArgument("sessionToken");
        }
        return this.validateJWT(sessionToken);
    }

    @Override
    public Token refreshSessionWithToken(String refreshToken) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)refreshToken)) {
            throw ServerCommonException.missingArguments("refresh token");
        }
        return this.refreshSession(refreshToken);
    }

    @Override
    public Token validateAndRefreshSessionWithTokens(String sessionToken, String refreshToken) throws DescopeException {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{sessionToken, refreshToken})) {
            throw ServerCommonException.missingArguments("Both sessionToken and refreshToken are empty");
        }
        if (StringUtils.isNotBlank((CharSequence)sessionToken)) {
            try {
                return this.validateSessionWithToken(sessionToken);
            }
            catch (Exception e) {
                if (StringUtils.isNotBlank((CharSequence)refreshToken)) {
                    return this.refreshSessionWithToken(refreshToken);
                }
                throw e;
            }
        }
        return this.refreshSessionWithToken(refreshToken);
    }

    @Override
    public Token exchangeAccessKey(String accessKey) throws DescopeException {
        return this.exchangeAccessKey(accessKey, null);
    }

    @Override
    public Token exchangeAccessKey(String accessKey, AccessKeyLoginOptions loginOptions) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)accessKey)) {
            throw ServerCommonException.invalidArgument("accessKey");
        }
        ApiProxy apiProxy = this.getApiProxy(accessKey);
        URI exchangeAccessKeyLinkURL = this.composeExchangeAccessKeyLinkURL();
        JWTResponse jwtResponse = apiProxy.post(exchangeAccessKeyLinkURL, CollectionUtils.mapOf("loginOptions", loginOptions), JWTResponse.class);
        AuthenticationInfo authenticationInfo = this.getAuthenticationInfo(jwtResponse);
        return authenticationInfo.getToken();
    }

    @Override
    public boolean validatePermissions(Token token, List<String> permissions) throws DescopeException {
        return this.validatePermissions(token, "", permissions);
    }

    @Override
    public boolean validatePermissions(Token token, String tenant, List<String> permissions) throws DescopeException {
        if (StringUtils.isNotBlank((CharSequence)tenant) && !this.isTenantAssociated(token, tenant)) {
            return false;
        }
        List<String> grantedPermissions = this.getPermissions(token, tenant);
        return org.apache.commons.collections4.CollectionUtils.isSubCollection(permissions, grantedPermissions);
    }

    @Override
    public List<String> getMatchedPermissions(Token token, List<String> permissions) throws DescopeException {
        return this.getMatchedPermissions(token, "", permissions);
    }

    @Override
    public List<String> getMatchedPermissions(Token token, String tenant, List<String> permissions) throws DescopeException {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(permissions) || StringUtils.isNotBlank((CharSequence)tenant) && !this.isTenantAssociated(token, tenant)) {
            return Collections.emptyList();
        }
        List<String> grantedPermissions = this.getPermissions(token, tenant);
        Collection intersection = org.apache.commons.collections4.CollectionUtils.intersection(permissions, grantedPermissions);
        return new ArrayList<String>(intersection);
    }

    @Override
    public boolean validateRoles(Token token, List<String> roles) throws DescopeException {
        return this.validateRoles(token, "", roles);
    }

    @Override
    public boolean validateRoles(Token token, String tenant, List<String> roles) throws DescopeException {
        if (StringUtils.isNotBlank((CharSequence)tenant) && !this.isTenantAssociated(token, tenant)) {
            return false;
        }
        List<String> grantedRoles = this.getRoles(token, tenant);
        return org.apache.commons.collections4.CollectionUtils.isSubCollection(roles, grantedRoles);
    }

    @Override
    public List<String> getMatchedRoles(Token token, List<String> roles) throws DescopeException {
        return this.getMatchedRoles(token, "", roles);
    }

    @Override
    public List<String> getMatchedRoles(Token token, String tenant, List<String> roles) throws DescopeException {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(roles) || StringUtils.isNotBlank((CharSequence)tenant) && !this.isTenantAssociated(token, tenant)) {
            return Collections.emptyList();
        }
        List<String> grantedRoles = this.getRoles(token, tenant);
        Collection intersection = org.apache.commons.collections4.CollectionUtils.intersection(roles, grantedRoles);
        return new ArrayList<String>(intersection);
    }

    @Override
    public List<String> getRoles(Token token, String tenant) throws DescopeException {
        return this.getAuthorizationClaimItems(token, tenant, "roles");
    }

    @Override
    public List<String> getRoles(Token token) throws DescopeException {
        return this.getAuthorizationClaimItems(token, "", "roles");
    }

    @Override
    public List<String> getPermissions(Token token, String tenant) throws DescopeException {
        return this.getAuthorizationClaimItems(token, tenant, "permissions");
    }

    @Override
    public List<String> getPermissions(Token token) throws DescopeException {
        return this.getAuthorizationClaimItems(token, "", "permissions");
    }

    @Override
    public void logout(String refreshToken) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)refreshToken)) {
            throw ServerCommonException.missingArguments("refresh token");
        }
        ApiProxy apiProxy = this.getApiProxy(refreshToken);
        URI logOutURL = this.composeLogOutLinkURL();
        apiProxy.post(logOutURL, null, JWTResponse.class);
    }

    @Override
    public void logoutAll(String refreshToken) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)refreshToken)) {
            throw ServerCommonException.missingArguments("refresh token");
        }
        ApiProxy apiProxy = this.getApiProxy(refreshToken);
        URI logOutAllURL = this.composeLogOutAllLinkURL();
        apiProxy.post(logOutAllURL, null, JWTResponse.class);
    }

    @Override
    public UserResponse me(String refreshToken) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)refreshToken)) {
            throw ServerCommonException.missingArguments("refresh token");
        }
        this.validateJWT(refreshToken);
        ApiProxy apiProxy = this.getApiProxy(refreshToken);
        return apiProxy.get(this.getUri("/v1/auth/me"), UserResponse.class);
    }

    @Override
    public List<UserHistoryResponse> history(String refreshToken) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)refreshToken)) {
            throw ServerCommonException.missingArguments("refresh token");
        }
        this.validateJWT(refreshToken);
        ApiProxy apiProxy = this.getApiProxy(refreshToken);
        return apiProxy.getArray(this.getUri("/v1/auth/me/history"), new TypeReference<List<UserHistoryResponse>>(){});
    }

    AuthenticationInfo exchangeToken(String code, URI url) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw ServerCommonException.invalidArgument("Code");
        }
        ExchangeTokenRequest request = new ExchangeTokenRequest(code);
        ApiProxy apiProxy = this.getApiProxy();
        JWTResponse jwtResponse = apiProxy.post(url, request, JWTResponse.class);
        return this.getAuthenticationInfo(jwtResponse);
    }

    private URI composeExchangeAccessKeyLinkURL() {
        return this.getUri("/v1/auth/accesskey/exchange");
    }

    private URI composeLogOutLinkURL() {
        return this.getUri("/v1/auth/logout");
    }

    private URI composeLogOutAllLinkURL() {
        return this.getUri("/v1/auth/logoutall");
    }
}

