/*
 * Decompiled with CFR 0.152.
 */
package com.descope.proxy.impl;

import com.descope.exception.RateLimitExceededException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.SdkInfo;
import com.descope.proxy.impl.ErrorDetails;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.function.Supplier;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractProxyImpl {
    private static final Logger log = LoggerFactory.getLogger(AbstractProxyImpl.class);
    private static final String RETRY_AFTER_HEADER = "Retry-After";
    private static final long DEFAULT_RETRY = 60L;
    private String authHeaderKey;
    private Supplier<String> authHeaderSupplier;
    private SdkInfo sdkInfo;

    AbstractProxyImpl() {
    }

    protected void setAuthHeader(String authHeaderKey, Supplier<String> authHeaderSupplier) {
        if (StringUtils.isNotBlank((CharSequence)authHeaderKey) && authHeaderSupplier != null) {
            this.authHeaderKey = authHeaderKey;
            this.authHeaderSupplier = authHeaderSupplier;
        } else if (StringUtils.isBlank((CharSequence)authHeaderKey)) {
            this.authHeaderKey = null;
            this.authHeaderSupplier = null;
        }
    }

    protected void setSdkInfo(SdkInfo sdkInfo) {
        this.sdkInfo = sdkInfo;
    }

    long getRetryHeader(ClassicHttpResponse res) {
        long retryPeriod = 60L;
        if (res.containsHeader(RETRY_AFTER_HEADER)) {
            try {
                retryPeriod = Long.parseLong(res.getFirstHeader(RETRY_AFTER_HEADER).getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retryPeriod;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <B, R> R exchange(ClassicHttpRequest req, final Class<R> returnClz, final TypeReference<R> typeReference) {
        this.addHeaders(req);
        log.debug(String.format("Sending %s request to %s", req.getMethod(), req.getRequestUri()));
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            Object object = httpClient.execute(req, new HttpClientResponseHandler<R>(){

                public R handleResponse(ClassicHttpResponse response) throws HttpException, IOException {
                    try (ClassicHttpResponse res = response;){
                        Object object;
                        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                        ByteArrayOutputStream bs = new ByteArrayOutputStream();
                        TeeInputStream tee = new TeeInputStream(res.getEntity().getContent(), (OutputStream)bs, true);
                        if (res.getCode() < 200 || response.getCode() > 299) {
                            if (res.getCode() == 429) {
                                throw new RateLimitExceededException("Rate limit exceeded", "E130429", AbstractProxyImpl.this.getRetryHeader(res));
                            }
                            try {
                                ErrorDetails errorDetails = (ErrorDetails)objectMapper.readValue((InputStream)tee, ErrorDetails.class);
                                log.debug(errorDetails.getActualMessage());
                                log.debug(bs.toString());
                                if ("E130429".equals(errorDetails.getErrorCode())) {
                                    throw new RateLimitExceededException(errorDetails.getActualMessage(), errorDetails.getErrorCode(), AbstractProxyImpl.this.getRetryHeader(res));
                                }
                                throw ServerCommonException.genericServerError(errorDetails.getActualMessage(), StringUtils.isBlank((CharSequence)errorDetails.getErrorCode()) ? String.valueOf(res.getCode()) : errorDetails.getErrorCode(), bs.toString());
                            }
                            catch (IOException e) {
                                throw ServerCommonException.genericServerError(bs.toString(), String.valueOf(res.getCode()), bs.toString());
                            }
                        }
                        try {
                            Object r;
                            Object object2 = r = returnClz != null ? objectMapper.readValue((InputStream)tee, returnClz) : objectMapper.readValue((InputStream)tee, typeReference);
                            if (log.isDebugEnabled()) {
                                String resStr = bs.toString();
                                log.debug(String.format("Received response %s", resStr.substring(0, resStr.length() > 10000 ? 10000 : resStr.length())));
                            }
                            object = r;
                        }
                        catch (Exception e) {
                            throw ServerCommonException.parseResponseError("Error parsing response", bs.toString(), e);
                        }
                        return object;
                    }
                }
            });
            return (R)object;
        }
    }

    private void addHeaders(ClassicHttpRequest req) {
        req.addHeader("Content-Type", (Object)"application/json");
        if (StringUtils.isNotBlank((CharSequence)this.authHeaderKey)) {
            String authHeaderVal = this.authHeaderSupplier.get();
            req.addHeader(this.authHeaderKey, (Object)authHeaderVal);
        }
        if (this.sdkInfo != null) {
            if (StringUtils.isNotBlank((CharSequence)this.sdkInfo.getJavaVersion())) {
                req.addHeader("x-descope-sdk-java-version", (Object)this.sdkInfo.getJavaVersion());
            }
            if (StringUtils.isNotBlank((CharSequence)this.sdkInfo.getName())) {
                req.addHeader("x-descope-sdk-name", (Object)this.sdkInfo.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)this.sdkInfo.getVersion())) {
                req.addHeader("x-descope-sdk-version", (Object)this.sdkInfo.getVersion());
            }
            if (StringUtils.isNotBlank((CharSequence)this.sdkInfo.getSha())) {
                req.addHeader("x-descope-sdk-sha", (Object)this.sdkInfo.getSha());
            }
        }
    }

    protected <B, R> R post(URI uri, B body, Class<R> returnClz) {
        ClassicRequestBuilder builder = ClassicRequestBuilder.post((URI)uri);
        if (body != null) {
            ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
            byte[] payload = objectMapper.writeValueAsBytes(body);
            builder.setEntity((HttpEntity)new ByteArrayEntity(payload, ContentType.APPLICATION_JSON));
        }
        return this.exchange(builder.build(), returnClz, null);
    }

    protected <B, R> R post(URI uri, B body, TypeReference<R> typeReference) {
        ClassicRequestBuilder builder = ClassicRequestBuilder.post((URI)uri);
        if (body != null) {
            ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
            byte[] payload = objectMapper.writeValueAsBytes(body);
            builder.setEntity((HttpEntity)new ByteArrayEntity(payload, ContentType.APPLICATION_JSON));
        }
        return this.exchange(builder.build(), null, typeReference);
    }

    protected <B, R> R patch(URI uri, B body, Class<R> returnClz) {
        ClassicRequestBuilder builder = ClassicRequestBuilder.patch((URI)uri);
        if (body != null) {
            ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
            byte[] payload = objectMapper.writeValueAsBytes(body);
            builder.setEntity((HttpEntity)new ByteArrayEntity(payload, ContentType.APPLICATION_JSON));
        }
        return this.exchange(builder.build(), returnClz, null);
    }

    protected <R> R get(URI uri, Class<R> returnClz) {
        return this.exchange(ClassicRequestBuilder.get((URI)uri).build(), returnClz, null);
    }

    protected <R> R get(URI uri, TypeReference<R> typeReference) {
        return this.exchange(ClassicRequestBuilder.get((URI)uri).build(), null, typeReference);
    }

    protected <B, R> R delete(URI uri, B body, Class<R> returnClz) {
        return this.exchange(ClassicRequestBuilder.delete((URI)uri).build(), returnClz, null);
    }
}

