/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk;

import com.descope.exception.ClientFunctionalException;
import com.descope.model.client.Client;
import com.descope.model.jwt.Token;
import com.descope.utils.JwtUtils;
import com.descope.utils.UriUtils;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class SdkServicesBase {
    protected final Client client;

    protected SdkServicesBase(Client client) {
        this.client = client;
    }

    protected URI composeURI(String base, String path) {
        URI uri = this.getUri(base);
        return UriUtils.addPath(uri, path);
    }

    protected URI getUri(String path) {
        return UriUtils.getUri(this.client.getUri(), path);
    }

    protected URI getQueryParamUri(String path, Map<String, String> params) {
        if (ObjectUtils.isNotEmpty(params)) {
            StringBuilder sb = new StringBuilder("?");
            for (Map.Entry<String, String> e : params.entrySet()) {
                if (sb.length() > 1) {
                    sb.append('&');
                }
                sb.append(URLEncoder.encode(e.getKey(), "UTF-8")).append('=').append(URLEncoder.encode(e.getValue(), "UTF-8"));
            }
            return UriUtils.getUri(this.client.getUri(), path.concat(sb.toString()));
        }
        return UriUtils.getUri(this.client.getUri(), path);
    }

    protected Token validateAndCreateToken(String jwt) {
        if (StringUtils.isBlank((CharSequence)jwt)) {
            throw ClientFunctionalException.invalidToken();
        }
        return JwtUtils.getToken(jwt, this.client);
    }
}

