/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.auth.OAuthResponse;
import com.descope.model.client.Client;
import com.descope.model.magiclink.LoginOptions;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.auth.SSOServiceProvider;
import com.descope.sdk.auth.impl.AuthenticationServiceImpl;
import com.descope.utils.CollectionUtils;
import com.descope.utils.JwtUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class SSOServiceProviderImpl
extends AuthenticationServiceImpl
implements SSOServiceProvider {
    SSOServiceProviderImpl(Client client) {
        super(client);
    }

    @Override
    public String start(String tenant, String redirectUrl, String prompt, LoginOptions loginOptions) {
        return this.start(tenant, redirectUrl, prompt, loginOptions, null);
    }

    @Override
    public String start(String tenant, String redirectUrl, String prompt, LoginOptions loginOptions, String refreshToken) throws DescopeException {
        ApiProxy apiProxy;
        if (StringUtils.isBlank((CharSequence)tenant)) {
            throw ServerCommonException.invalidArgument("Tenant");
        }
        Map<String, String> request = CollectionUtils.mapOf("tenant", tenant);
        if (StringUtils.isNotBlank((CharSequence)redirectUrl)) {
            request.put("redirectURL", redirectUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)prompt)) {
            request.put("prompt", prompt);
        }
        if (JwtUtils.isJWTRequired(loginOptions)) {
            if (StringUtils.isBlank((CharSequence)refreshToken)) {
                throw ServerCommonException.invalidArgument("refreshToken");
            }
            apiProxy = this.getApiProxy(refreshToken);
        } else {
            apiProxy = this.getApiProxy();
        }
        return apiProxy.post(this.getQueryParamUri("/v1/auth/sso/authorize", request), loginOptions, OAuthResponse.class).getUrl();
    }

    @Override
    public AuthenticationInfo exchangeToken(String code) throws DescopeException {
        return this.exchangeToken(code, this.getUri("/v1/auth/sso/exchange"));
    }
}

