/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.enums.ProjectTag;
import com.descope.exception.DescopeException;
import com.descope.model.client.Client;
import com.descope.model.project.ExportProjectResponse;
import com.descope.model.project.NewProjectResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.ProjectService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import com.descope.utils.CollectionUtils;
import java.util.Map;

class ProjectServiceImpl
extends ManagementsBase
implements ProjectService {
    ProjectServiceImpl(Client client) {
        super(client);
    }

    @Override
    public void updateName(String name) throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, String> request = CollectionUtils.mapOf("name", name);
        apiProxy.post(this.getUri("/v1/mgmt/project/update/name"), request, Void.class);
    }

    @Override
    public NewProjectResponse cloneProject(String name, ProjectTag tag) throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, ProjectTag> request = CollectionUtils.mapOf("name", name, "tag", tag);
        NewProjectResponse resp = apiProxy.post(this.getUri("/v1/mgmt/project/clone"), request, NewProjectResponse.class);
        return resp;
    }

    @Override
    public ExportProjectResponse exportProject() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        ExportProjectResponse resp = apiProxy.post(this.getUri("/v1/mgmt/project/export"), null, ExportProjectResponse.class);
        return resp;
    }

    @Override
    public void importProject(Map<String, Object> files) throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, Map<String, Object>> request = CollectionUtils.mapOf("files", files);
        apiProxy.post(this.getUri("/v1/mgmt/project/import"), request, Void.class);
    }
}

