/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.mgmt.IDResponse;
import com.descope.model.ssoapp.OIDCApplicationRequest;
import com.descope.model.ssoapp.SAMLApplicationRequest;
import com.descope.model.ssoapp.SSOApplication;
import com.descope.model.ssoapp.SSOApplications;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.SsoApplicationService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import com.descope.utils.CollectionUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class SsoApplicationServiceImpl
extends ManagementsBase
implements SsoApplicationService {
    SsoApplicationServiceImpl(Client client) {
        super(client);
    }

    @Override
    public String createOIDCApplication(OIDCApplicationRequest appRequest) throws DescopeException {
        if (appRequest == null) {
            throw ServerCommonException.invalidArgument("appRequest");
        }
        if (StringUtils.isBlank((CharSequence)appRequest.getName())) {
            throw ServerCommonException.invalidArgument("appRequest.Name");
        }
        ApiProxy apiProxy = this.getApiProxy();
        IDResponse id = apiProxy.post(this.getUri("/v1/mgmt/sso/idp/app/oidc/create"), appRequest, IDResponse.class);
        return id.getId();
    }

    @Override
    public String createSAMLApplication(SAMLApplicationRequest appRequest) throws DescopeException {
        if (appRequest == null) {
            throw ServerCommonException.invalidArgument("appRequest");
        }
        if (StringUtils.isBlank((CharSequence)appRequest.getName())) {
            throw ServerCommonException.invalidArgument("appRequest.Name");
        }
        ApiProxy apiProxy = this.getApiProxy();
        IDResponse id = apiProxy.post(this.getUri("/v1/mgmt/sso/idp/app/saml/create"), appRequest, IDResponse.class);
        return id.getId();
    }

    @Override
    public void updateOIDCApplication(OIDCApplicationRequest appRequest) throws DescopeException {
        if (appRequest == null) {
            throw ServerCommonException.invalidArgument("appRequest");
        }
        if (StringUtils.isBlank((CharSequence)appRequest.getId())) {
            throw ServerCommonException.invalidArgument("appRequest.Id");
        }
        if (StringUtils.isBlank((CharSequence)appRequest.getName())) {
            throw ServerCommonException.invalidArgument("appRequest.Name");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/sso/idp/app/oidc/update"), appRequest, Void.class);
    }

    @Override
    public void updateSAMLApplication(SAMLApplicationRequest appRequest) throws DescopeException {
        if (appRequest == null) {
            throw ServerCommonException.invalidArgument("appRequest");
        }
        if (StringUtils.isBlank((CharSequence)appRequest.getId())) {
            throw ServerCommonException.invalidArgument("appRequest.Id");
        }
        if (StringUtils.isBlank((CharSequence)appRequest.getName())) {
            throw ServerCommonException.invalidArgument("appRequest.Name");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/sso/idp/app/saml/update"), appRequest, Void.class);
    }

    @Override
    public void delete(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/sso/idp/app/delete"), CollectionUtils.mapOf("id", id), Void.class);
    }

    @Override
    public SSOApplication load(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getQueryParamUri("/v1/mgmt/sso/idp/app/load", CollectionUtils.mapOf("id", id)), SSOApplication.class);
    }

    @Override
    public List<SSOApplication> loadAll() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        SSOApplications apps = apiProxy.get(this.getUri("/v1/mgmt/sso/idp/apps/load"), SSOApplications.class);
        return apps.getApps();
    }
}

