/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.ClientFunctionalException;
import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.client.Client;
import com.descope.model.jwt.MgmtSignUpUser;
import com.descope.model.jwt.Token;
import com.descope.model.jwt.request.ManagementSignInRequest;
import com.descope.model.jwt.request.ManagementSignUpRequest;
import com.descope.model.jwt.request.UpdateJwtRequest;
import com.descope.model.jwt.response.JWTResponse;
import com.descope.model.jwt.response.UpdateJwtResponse;
import com.descope.model.magiclink.LoginOptions;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.JwtService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class JwtServiceImpl
extends ManagementsBase
implements JwtService {
    JwtServiceImpl(Client client) {
        super(client);
    }

    @Override
    public Token updateJWTWithCustomClaims(String jwt, Map<String, Object> customClaims) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)jwt)) {
            throw ServerCommonException.invalidArgument("JWT");
        }
        UpdateJwtRequest updateJwtRequest = new UpdateJwtRequest(jwt, customClaims);
        URI updateJwtUri = this.composeUpdateJwtUri();
        ApiProxy apiProxy = this.getApiProxy();
        UpdateJwtResponse jwtResponse = apiProxy.post(updateJwtUri, updateJwtRequest, UpdateJwtResponse.class);
        return this.validateAndCreateToken(jwtResponse.getJwt());
    }

    @Override
    public AuthenticationInfo signIn(String loginId, LoginOptions loginOptions) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("loginId");
        }
        if (loginOptions == null) {
            loginOptions = new LoginOptions();
        }
        if (loginOptions.isJWTRequired() && StringUtils.isBlank((CharSequence)loginOptions.getJwt())) {
            throw ServerCommonException.invalidArgument("JWT is required for step-up or MFA authentication");
        }
        ManagementSignInRequest request = new ManagementSignInRequest(loginId, loginOptions.isStepup(), loginOptions.isMfa(), loginOptions.isRevokeOtherSessions(), loginOptions.getCustomClaims(), loginOptions.getJwt());
        URI signInUri = this.getUri("/v1/mgmt/auth/signin");
        ApiProxy apiProxy = this.getApiProxy();
        JWTResponse jwtResponse = apiProxy.post(signInUri, request, JWTResponse.class);
        return this.validateAndCreateAuthInfo(jwtResponse);
    }

    @Override
    public AuthenticationInfo signUpOrIn(String loginId, MgmtSignUpUser signUpUserDetails) throws DescopeException {
        return this.signUp(loginId, signUpUserDetails, "/v1/mgmt/auth/signup-in");
    }

    @Override
    public AuthenticationInfo signUp(String loginId, MgmtSignUpUser signUpUserDetails) throws DescopeException {
        return this.signUp(loginId, signUpUserDetails, "/v1/mgmt/auth/signup");
    }

    private AuthenticationInfo signUp(String loginId, MgmtSignUpUser signUpUserDetails, String path) {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("loginId");
        }
        if (signUpUserDetails == null) {
            signUpUserDetails = new MgmtSignUpUser();
        }
        ManagementSignUpRequest request = new ManagementSignUpRequest(loginId, signUpUserDetails.getUser(), signUpUserDetails.isVerifiedEmail(), signUpUserDetails.isVerifiedPhone(), signUpUserDetails.getSsoAppId(), signUpUserDetails.getCustomClaims());
        URI uri = this.getUri(path);
        ApiProxy apiProxy = this.getApiProxy();
        JWTResponse jwtResponse = apiProxy.post(uri, request, JWTResponse.class);
        return this.validateAndCreateAuthInfo(jwtResponse);
    }

    private AuthenticationInfo validateAndCreateAuthInfo(JWTResponse jwtResponse) throws DescopeException {
        if (jwtResponse == null) {
            throw ClientFunctionalException.invalidToken();
        }
        Token sessionToken = this.validateAndCreateToken(jwtResponse.getSessionJwt());
        Token refreshToken = this.validateAndCreateToken(jwtResponse.getRefreshJwt());
        return new AuthenticationInfo(sessionToken, refreshToken, jwtResponse.getUser(), jwtResponse.getFirstSeen());
    }

    private URI composeUpdateJwtUri() {
        return this.getUri("/v1/mgmt/jwt/update");
    }
}

