/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.outbound.DeleteOutboundAppUserTokensRequest;
import com.descope.model.outbound.FetchOutboundAppUserTokenRequest;
import com.descope.model.outbound.FetchOutboundAppUserTokenResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.OutboundAppsService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import com.descope.utils.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OutboundAppsServiceImpl
extends ManagementsBase
implements OutboundAppsService {
    OutboundAppsServiceImpl(Client client) {
        super(client);
    }

    @Override
    public FetchOutboundAppUserTokenResponse fetchOutboundAppUserToken(FetchOutboundAppUserTokenRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getAppId())) {
            throw ServerCommonException.invalidArgument("appId");
        }
        if (StringUtils.isBlank((CharSequence)request.getUserId())) {
            throw ServerCommonException.invalidArgument("userId");
        }
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(request.getScopes())) {
            throw ServerCommonException.invalidArgument("scopes");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/outbound/app/user/token"), request, FetchOutboundAppUserTokenResponse.class);
    }

    @Override
    public void deleteOutboundAppTokenById(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.delete(this.getUri("/v1/mgmt/outbound/token"), CollectionUtils.mapOf("id", id), Void.class);
    }

    @Override
    public void deleteOutboundAppUserTokens(DeleteOutboundAppUserTokensRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getAppId())) {
            throw ServerCommonException.invalidArgument("appId");
        }
        if (StringUtils.isBlank((CharSequence)request.getUserId())) {
            throw ServerCommonException.invalidArgument("userId");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.delete(this.getUri("/v1/mgmt/outbound/tokens"), request, Void.class);
    }
}

