/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.passwordsettings.PasswordSettings;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.PasswordSettingsService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import com.descope.utils.CollectionUtils;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

class PasswordSettingsServiceImpl
extends ManagementsBase
implements PasswordSettingsService {
    PasswordSettingsServiceImpl(Client client) {
        super(client);
    }

    @Override
    public PasswordSettings getSettings() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.managementPasswordSettingsUri(null), PasswordSettings.class);
    }

    @Override
    public PasswordSettings getSettings(String tenantId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw ServerCommonException.invalidArgument("tenantId");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.managementPasswordSettingsUri(tenantId), PasswordSettings.class);
    }

    @Override
    public void configureSettings(PasswordSettings settings) throws DescopeException {
        this.configureSettings(null, settings, true);
    }

    @Override
    public void configureSettings(String id, PasswordSettings settings) throws DescopeException {
        this.configureSettings(id, settings, false);
    }

    private void configureSettings(String id, PasswordSettings settings, boolean ignoreEmptyId) throws DescopeException {
        if (!ignoreEmptyId && StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        if (settings == null) {
            throw ServerCommonException.invalidArgument("settings");
        }
        HashMap<String, Object> req = new HashMap<String, Object>();
        CollectionUtils.addIfNotBlank(req, "tenantId", id);
        CollectionUtils.addIfNotNull(req, "enabled", settings.getEnabled());
        CollectionUtils.addIfNotNull(req, "minLength", settings.getMinLength());
        CollectionUtils.addIfNotNull(req, "lowercase", settings.getLowercase());
        CollectionUtils.addIfNotNull(req, "uppercase", settings.getUppercase());
        CollectionUtils.addIfNotNull(req, "number", settings.getNumber());
        CollectionUtils.addIfNotNull(req, "nonAlphanumeric", settings.getNonAlphanumeric());
        CollectionUtils.addIfNotNull(req, "expiration", settings.getExpiration());
        CollectionUtils.addIfNotNull(req, "expirationWeeks", settings.getExpirationWeeks());
        CollectionUtils.addIfNotNull(req, "reuse", settings.getReuse());
        CollectionUtils.addIfNotNull(req, "reuseAmount", settings.getReuseAmount());
        CollectionUtils.addIfNotNull(req, "lock", settings.getLock());
        CollectionUtils.addIfNotNull(req, "lockAttempts", settings.getLockAttempts());
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.managementPasswordSettingsUri(null), req, Void.class);
    }

    private URI managementPasswordSettingsUri(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return this.getUri("/v1/mgmt/password/settings");
        }
        return this.getQueryParamUri("/v1/mgmt/password/settings", CollectionUtils.mapOf("tenantId", id));
    }
}

