/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.exception.DescopeException;
import com.descope.model.auth.AuthParams;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.client.Client;
import com.descope.model.magiclink.LoginOptions;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.auth.SAMLService;
import com.descope.sdk.auth.impl.AuthenticationServiceImpl;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

class SAMLServiceImpl
extends AuthenticationServiceImpl
implements SAMLService {
    SAMLServiceImpl(Client client, AuthParams authParams) {
        super(client, authParams);
    }

    @Override
    public String start(String tenant, String returnURL, LoginOptions loginOptions) throws DescopeException {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("provider", tenant);
        if (StringUtils.isNotBlank((CharSequence)returnURL)) {
            request.put("redirectURL", returnURL);
        }
        URI samlStartURLAML = this.composeSAMLStartURL();
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(samlStartURLAML, request, String.class);
    }

    @Override
    public AuthenticationInfo exchangeToken(String code) throws DescopeException {
        return this.exchangeToken(code, this.composeOAuthExchangeTokenURL());
    }

    private URI composeSAMLStartURL() {
        return this.getUri("/v1/auth/saml/authorize");
    }

    private URI composeOAuthExchangeTokenURL() {
        return this.getUri("/v1/auth/saml/exchange");
    }
}

