/*
 * Decompiled with CFR 0.152.
 */
package com.descope.utils;

import com.descope.model.jwt.Token;
import com.descope.model.magiclink.LoginOptions;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class JwtUtils {
    private static final long SKEW_SECONDS = TimeUnit.SECONDS.toSeconds(5L);

    public static Token getToken(String jwt, Key key) {
        Jws<Claims> claimsJws = JwtUtils.getClaimsJws(jwt, key);
        JwsHeader header = (JwsHeader)claimsJws.getHeader();
        Claims claims = (Claims)claimsJws.getBody();
        return Token.builder().jwt(jwt).projectId(header.getKeyId()).id(claims.getSubject()).expiration(claims.getExpiration().getTime()).refreshExpiration((Date)claims.get("rexp", Date.class)).claims((Map<String, Object>)claims).build();
    }

    public static Jws<Claims> getClaimsJws(String jwt, Key key) {
        JwtParser jwtParser = Jwts.parserBuilder().setSigningKey(key).setAllowedClockSkewSeconds(SKEW_SECONDS).build();
        Jws claimsJws = jwtParser.parseClaimsJws(jwt);
        return claimsJws;
    }

    public static boolean isJWTRequired(LoginOptions loginOptions) {
        return loginOptions != null && (loginOptions.isStepup() || loginOptions.isMfa());
    }

    private JwtUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

