/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.exception.DescopeException;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.auth.OAuthResponse;
import com.descope.model.client.Client;
import com.descope.model.magiclink.LoginOptions;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.auth.OAuthService;
import com.descope.sdk.auth.impl.AuthenticationServiceImpl;
import com.descope.utils.CollectionUtils;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class OAuthServiceImpl
extends AuthenticationServiceImpl
implements OAuthService {
    OAuthServiceImpl(Client client) {
        super(client);
    }

    protected String startWithUrl(String url, String provider, String redirectURL, LoginOptions loginOptions, Map<String, String> authParams) throws DescopeException {
        Map<String, String> params = CollectionUtils.mapOf("provider", provider);
        if (StringUtils.isNotBlank((CharSequence)redirectURL)) {
            params.put("redirectURL", redirectURL);
        }
        URI oauthURL = this.getQueryParamUri(url, params);
        ApiProxy apiProxy = this.getApiProxy();
        OAuthResponse res = apiProxy.post(oauthURL, loginOptions, OAuthResponse.class);
        url = res.getUrl();
        String resUrl = this.appendQueryParams(url, authParams);
        return resUrl;
    }

    @Override
    public String start(String provider, String redirectURL, LoginOptions loginOptions) throws DescopeException {
        return this.startWithUrl("/v1/auth/oauth/authorize", provider, redirectURL, loginOptions, null);
    }

    @Override
    public String start(String provider, String redirectURL, LoginOptions loginOptions, Map<String, String> authParams) throws DescopeException {
        return this.startWithUrl("/v1/auth/oauth/authorize", provider, redirectURL, loginOptions, authParams);
    }

    @Override
    public String startSignIn(String provider, String redirectURL, LoginOptions loginOptions) throws DescopeException {
        return this.startWithUrl("/v1/auth/oauth/authorize/signin", provider, redirectURL, loginOptions, null);
    }

    @Override
    public String startSignIn(String provider, String redirectURL, LoginOptions loginOptions, Map<String, String> authParams) throws DescopeException {
        return this.startWithUrl("/v1/auth/oauth/authorize/signin", provider, redirectURL, loginOptions, authParams);
    }

    @Override
    public String startSignUp(String provider, String redirectURL, LoginOptions loginOptions) throws DescopeException {
        return this.startWithUrl("/v1/auth/oauth/authorize/signup", provider, redirectURL, loginOptions, null);
    }

    @Override
    public String startSignUp(String provider, String redirectURL, LoginOptions loginOptions, Map<String, String> authParams) throws DescopeException {
        return this.startWithUrl("/v1/auth/oauth/authorize/signup", provider, redirectURL, loginOptions, authParams);
    }

    @Override
    public AuthenticationInfo exchangeToken(String code) throws DescopeException {
        return this.exchangeToken(code, this.composeOAuthExchangeTokenURL());
    }

    private URI composeOAuthExchangeTokenURL() {
        return this.getUri("/v1/auth/oauth/exchange");
    }
}

