/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.sso.AttributeMapping;
import com.descope.model.sso.RoleMapping;
import com.descope.model.sso.SSOOIDCSettings;
import com.descope.model.sso.SSOSAMLSettings;
import com.descope.model.sso.SSOSAMLSettingsByMetadata;
import com.descope.model.sso.SSOSettingsResponse;
import com.descope.model.sso.SSOTenantSettingsResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.SsoService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import com.descope.utils.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class SsoServiceImpl
extends ManagementsBase
implements SsoService {
    SsoServiceImpl(Client client) {
        super(client);
    }

    @Override
    public SSOTenantSettingsResponse loadSettings(String tenantId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw ServerCommonException.invalidArgument("TenantId");
        }
        Map<String, String> params = CollectionUtils.mapOf("tenantId", tenantId);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getQueryParamUri("/v2/mgmt/sso/settings", params), SSOTenantSettingsResponse.class);
    }

    @Override
    public void configureSAMLSettings(String tenantId, SSOSAMLSettings settings, String redirectUrl, List<String> domains) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw ServerCommonException.invalidArgument("TenantId");
        }
        if (settings == null) {
            throw ServerCommonException.invalidArgument("settings");
        }
        if (StringUtils.isBlank((CharSequence)settings.getIdpUrl())) {
            throw ServerCommonException.invalidArgument("idpUrl");
        }
        if (StringUtils.isBlank((CharSequence)settings.getIdpCert())) {
            throw ServerCommonException.invalidArgument("idpCert");
        }
        if (StringUtils.isBlank((CharSequence)settings.getEntityId())) {
            throw ServerCommonException.invalidArgument("entityId");
        }
        Map<String, SSOSAMLSettings> req = CollectionUtils.mapOf("tenantId", tenantId, "redirectUrl", redirectUrl, "domains", domains, "settings", settings);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/sso/saml"), req, Void.class);
    }

    @Override
    public void configureSAMLSettingsByMetadata(String tenantId, SSOSAMLSettingsByMetadata settings, String redirectUrl, List<String> domains) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw ServerCommonException.invalidArgument("TenantId");
        }
        if (settings == null) {
            throw ServerCommonException.invalidArgument("settings");
        }
        if (StringUtils.isBlank((CharSequence)settings.getIdpMetadataUrl())) {
            throw ServerCommonException.invalidArgument("idpMetadataURL");
        }
        Map<String, SSOSAMLSettingsByMetadata> req = CollectionUtils.mapOf("tenantId", tenantId, "redirectUrl", redirectUrl, "domains", domains, "settings", settings);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/sso/saml/metadata"), req, Void.class);
    }

    @Override
    public void configureOIDCSettings(String tenantId, SSOOIDCSettings settings, List<String> domains) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw ServerCommonException.invalidArgument("TenantId");
        }
        if (settings == null) {
            throw ServerCommonException.invalidArgument("settings");
        }
        Map<String, SSOOIDCSettings> req = CollectionUtils.mapOf("tenantId", tenantId, "domains", domains, "settings", settings);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/sso/oidc"), req, Void.class);
    }

    @Override
    public void deleteSettings(String tenantId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw ServerCommonException.invalidArgument("TenantId");
        }
        Map<String, String> request = CollectionUtils.mapOf("tenantId", tenantId);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.delete(this.getQueryParamUri("/v1/mgmt/sso/settings", request), null, Void.class);
    }

    @Override
    public SSOSettingsResponse getSettings(String tenantID) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw ServerCommonException.invalidArgument("TenantId");
        }
        Map<String, String> params = CollectionUtils.mapOf("tenantId", tenantID);
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getQueryParamUri("/v1/mgmt/sso/settings", params), SSOSettingsResponse.class);
    }

    @Override
    public void configureSettings(String tenantID, String idpURL, String idpCert, String entityID, String redirectURL, List<String> domains) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw ServerCommonException.invalidArgument("TenantID");
        }
        if (StringUtils.isBlank((CharSequence)idpURL)) {
            throw ServerCommonException.invalidArgument("IdpURL");
        }
        if (StringUtils.isBlank((CharSequence)idpCert)) {
            throw ServerCommonException.invalidArgument("IdpCert");
        }
        if (StringUtils.isBlank((CharSequence)entityID)) {
            throw ServerCommonException.invalidArgument("EntityID");
        }
        if (StringUtils.isBlank((CharSequence)redirectURL)) {
            throw ServerCommonException.invalidArgument("RedirectURL");
        }
        Map<String, List<String>> request = CollectionUtils.mapOf("tenantId", tenantID, "idpURL", idpURL, "idpCert", idpCert, "entityId", entityID, "redirectURL", redirectURL, "domains", domains);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/sso/settings"), request, Void.class);
    }

    @Override
    public void configureMetadata(String tenantID, String idpMetadataURL) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw ServerCommonException.invalidArgument("TenantID");
        }
        if (StringUtils.isBlank((CharSequence)idpMetadataURL)) {
            throw ServerCommonException.invalidArgument("IdpMetadataURL");
        }
        Map<String, String> request = CollectionUtils.mapOf("tenantId", tenantID, "idpMetadataURL", idpMetadataURL);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/sso/metadata"), request, Void.class);
    }

    @Override
    public void configureMapping(String tenantID, List<RoleMapping> roleMapping, AttributeMapping attributeMapping) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw ServerCommonException.invalidArgument("TenantID");
        }
        Map<String, AttributeMapping> request = CollectionUtils.mapOf("tenantId", tenantID, "roleMappings", roleMapping, "attributeMapping", attributeMapping);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/sso/mapping"), request, Void.class);
    }
}

