/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk;

import com.descope.exception.ClientFunctionalException;
import com.descope.model.client.Client;
import com.descope.model.jwt.Token;
import com.descope.sdk.auth.impl.KeyProvider;
import com.descope.utils.JwtUtils;
import com.descope.utils.UriUtils;
import java.net.URI;
import java.security.Key;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class SdkServicesBase {
    protected final Client client;

    protected SdkServicesBase(Client client, String projectId) {
        this.client = client;
    }

    protected URI composeURI(String base, String path) {
        URI uri = this.getUri(base);
        return UriUtils.addPath(uri, path);
    }

    protected URI getUri(String path) {
        return UriUtils.getUri(this.client.getUri(), path);
    }

    protected URI getQueryParamUri(String path, Map<String, String> params) {
        if (ObjectUtils.isNotEmpty(params)) {
            String queryParams = params.entrySet().stream().map(p -> (String)p.getKey() + "=" + (String)p.getValue()).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
            return UriUtils.getUri(this.client.getUri(), path.concat("?" + queryParams));
        }
        return UriUtils.getUri(this.client.getUri(), path);
    }

    protected Key requestKeys() {
        Key key = this.client.getProvidedKey();
        if (key != null) {
            return this.client.getProvidedKey();
        }
        key = KeyProvider.getKey(this.client.getParams().getProjectId(), this.client.getUri(), this.client.getSdkInfo());
        this.client.setProvidedKey(key);
        return key;
    }

    protected Token validateAndCreateToken(String jwt) {
        if (StringUtils.isBlank((CharSequence)jwt)) {
            throw ClientFunctionalException.invalidToken();
        }
        return JwtUtils.getToken(jwt, this.requestKeys());
    }
}

