/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.auth.AuthParams;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.client.Client;
import com.descope.model.jwt.response.JWTResponse;
import com.descope.model.magiclink.LoginOptions;
import com.descope.model.otp.AuthenticationVerifyRequestBody;
import com.descope.model.totp.TOTPResponse;
import com.descope.model.totp.TotpSignUpRequestBody;
import com.descope.model.user.User;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.auth.TOTPService;
import com.descope.sdk.auth.impl.AuthenticationServiceImpl;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

class TOTPServiceImpl
extends AuthenticationServiceImpl
implements TOTPService {
    TOTPServiceImpl(Client client, AuthParams authParams) {
        super(client, authParams);
    }

    @Override
    public TOTPResponse signUp(String loginId, User user) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("loginId");
        }
        URI totpSignUpURL = this.composeSignUpTOTPURL();
        TotpSignUpRequestBody signUpRequest = TotpSignUpRequestBody.builder().loginId(loginId).user(user).build();
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(totpSignUpURL, signUpRequest, TOTPResponse.class);
    }

    @Override
    public AuthenticationInfo signInCode(String loginId, String code, LoginOptions loginOptions) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("loginId");
        }
        AuthenticationVerifyRequestBody authenticationVerifyRequestBody = new AuthenticationVerifyRequestBody(loginId, code, loginOptions);
        URI totpVerifyCode = this.composeVerifyTOTPCodeURL();
        ApiProxy apiProxy = this.getApiProxy();
        JWTResponse jwtResponse = apiProxy.post(totpVerifyCode, authenticationVerifyRequestBody, JWTResponse.class);
        return this.getAuthenticationInfo(jwtResponse);
    }

    @Override
    public TOTPResponse updateUser(String loginId) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("loginId");
        }
        URI totpUpdateUser = this.composeUpdateTOTPURL();
        TotpSignUpRequestBody signUpRequest = TotpSignUpRequestBody.builder().loginId(loginId).build();
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(totpUpdateUser, signUpRequest, TOTPResponse.class);
    }

    private URI composeSignUpTOTPURL() {
        return this.getUri("/v1/auth/totp/signup");
    }

    private URI composeUpdateTOTPURL() {
        return this.getUri("/v1/auth/totp/update");
    }

    private URI composeVerifyTOTPCodeURL() {
        return this.getUri("/v1/auth/totp/verify");
    }
}

