/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.outbound.FetchLatestOutboundAppUserTokenRequest;
import com.descope.model.outbound.FetchOutboundAppTenantTokenRequest;
import com.descope.model.outbound.FetchOutboundAppTenantTokenResponse;
import com.descope.model.outbound.FetchOutboundAppUserTokenRequest;
import com.descope.model.outbound.FetchOutboundAppUserTokenResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.OutboundAppsByTokenService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

class OutboundAppsByTokenServiceImpl
extends ManagementsBase
implements OutboundAppsByTokenService {
    OutboundAppsByTokenServiceImpl(Client client) {
        super(client);
    }

    @Override
    public FetchOutboundAppUserTokenResponse fetchOutboundAppUserTokenByScopes(String token, FetchOutboundAppUserTokenRequest request) throws DescopeException {
        this.validateToken(token);
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getAppId())) {
            throw ServerCommonException.invalidArgument("appId");
        }
        if (StringUtils.isBlank((CharSequence)request.getUserId())) {
            throw ServerCommonException.invalidArgument("userId");
        }
        if (CollectionUtils.isEmpty(request.getScopes())) {
            throw ServerCommonException.invalidArgument("scopes");
        }
        ApiProxy apiProxy = this.getApiProxyWithBearer(token);
        return apiProxy.post(this.getUri("/v1/mgmt/outbound/app/user/token"), request, FetchOutboundAppUserTokenResponse.class);
    }

    @Override
    public FetchOutboundAppUserTokenResponse fetchLatestOutboundAppUserToken(String token, FetchLatestOutboundAppUserTokenRequest request) throws DescopeException {
        this.validateToken(token);
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getAppId())) {
            throw ServerCommonException.invalidArgument("appId");
        }
        if (StringUtils.isBlank((CharSequence)request.getUserId())) {
            throw ServerCommonException.invalidArgument("userId");
        }
        ApiProxy apiProxy = this.getApiProxyWithBearer(token);
        return apiProxy.post(this.getUri("/v1/mgmt/outbound/app/user/token/latest"), request, FetchOutboundAppUserTokenResponse.class);
    }

    @Override
    public FetchOutboundAppTenantTokenResponse fetchOutboundAppTenantTokenByScopes(String token, FetchOutboundAppTenantTokenRequest request) throws DescopeException {
        this.validateToken(token);
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getAppId())) {
            throw ServerCommonException.invalidArgument("appId");
        }
        if (StringUtils.isBlank((CharSequence)request.getTenantId())) {
            throw ServerCommonException.invalidArgument("tenantId");
        }
        if (CollectionUtils.isEmpty(request.getScopes())) {
            throw ServerCommonException.invalidArgument("scopes");
        }
        ApiProxy apiProxy = this.getApiProxyWithBearer(token);
        return apiProxy.post(this.getUri("/v1/mgmt/outbound/app/tenant/token"), request, FetchOutboundAppTenantTokenResponse.class);
    }

    @Override
    public FetchOutboundAppTenantTokenResponse fetchLatestOutboundAppTenantToken(String token, FetchOutboundAppTenantTokenRequest request) throws DescopeException {
        this.validateToken(token);
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getAppId())) {
            throw ServerCommonException.invalidArgument("appId");
        }
        if (StringUtils.isBlank((CharSequence)request.getTenantId())) {
            throw ServerCommonException.invalidArgument("tenantId");
        }
        ApiProxy apiProxy = this.getApiProxyWithBearer(token);
        return apiProxy.post(this.getUri("/v1/mgmt/outbound/app/tenant/token/latest"), request, FetchOutboundAppTenantTokenResponse.class);
    }

    private void validateToken(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw ServerCommonException.invalidArgument("token");
        }
    }
}

