/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.enums.DeliveryMethod;
import com.descope.exception.ServerCommonException;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.client.Client;
import com.descope.model.jwt.Token;
import com.descope.model.jwt.response.JWTResponse;
import com.descope.model.magiclink.response.Masked;
import com.descope.model.magiclink.response.MaskedEmailRes;
import com.descope.model.magiclink.response.MaskedPhoneRes;
import com.descope.model.user.User;
import com.descope.proxy.ApiProxy;
import com.descope.proxy.impl.ApiProxyBuilder;
import com.descope.sdk.SdkServicesBase;
import com.descope.sdk.auth.AuthenticationService;
import com.descope.utils.JwtUtils;
import com.descope.utils.PatternUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

abstract class AuthenticationsBase
extends SdkServicesBase
implements AuthenticationService {
    AuthenticationsBase(Client client) {
        super(client);
    }

    ApiProxy getApiProxy() {
        String projectId = this.client.getProjectId();
        if (StringUtils.isNotBlank((CharSequence)projectId)) {
            return ApiProxyBuilder.buildProxy(() -> "Bearer " + projectId, this.client);
        }
        return ApiProxyBuilder.buildProxy(this.client.getSdkInfo());
    }

    ApiProxy getApiProxy(String refreshToken) {
        String projectId = this.client.getProjectId();
        if (StringUtils.isBlank((CharSequence)refreshToken) || StringUtils.isBlank((CharSequence)projectId)) {
            return this.getApiProxy();
        }
        String token = String.format("Bearer %s:%s", projectId, refreshToken);
        return ApiProxyBuilder.buildProxy(() -> token, this.client);
    }

    void verifyDeliveryMethod(DeliveryMethod deliveryMethod, String loginId, User user) {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        switch (deliveryMethod) {
            case SMS: 
            case VOICE: 
            case WHATSAPP: {
                String phone = user.getPhone();
                if (StringUtils.isBlank((CharSequence)phone)) {
                    phone = loginId;
                }
                if (PatternUtils.PHONE_PATTERN.matcher(phone).matches()) break;
                throw ServerCommonException.invalidArgument("user.phone");
            }
            case EMAIL: {
                String email = user.getEmail();
                if (StringUtils.isBlank((CharSequence)email)) {
                    email = loginId;
                    user.setEmail(email);
                }
                if (PatternUtils.EMAIL_PATTERN.matcher(email).matches()) break;
                throw ServerCommonException.invalidArgument("user.email");
            }
            default: {
                throw ServerCommonException.invalidArgument("DeliveryMethod");
            }
        }
    }

    Class<? extends Masked> getMaskedValue(DeliveryMethod deliveryMethod) {
        switch (deliveryMethod) {
            case SMS: 
            case VOICE: 
            case WHATSAPP: {
                return MaskedPhoneRes.class;
            }
            case EMAIL: {
                return MaskedEmailRes.class;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)deliveryMethod));
    }

    String getSessionTokenFromBearerToken(String bearerToken) {
        String[] sessionTokens;
        if (StringUtils.isNotBlank((CharSequence)bearerToken) && (sessionTokens = bearerToken.split("Bearer ")).length == 2) {
            try {
                return sessionTokens[1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw ServerCommonException.invalidArgument("bearerToken");
            }
        }
        throw ServerCommonException.invalidArgument("bearerToken");
    }

    Token validateJWT(String jwt) {
        return JwtUtils.getToken(jwt, this.client);
    }

    AuthenticationInfo refreshSession(String refreshToken) {
        this.validateJWT(refreshToken);
        ApiProxy apiProxy = this.getApiProxy(refreshToken);
        URI refreshTokenLinkURL = this.composeRefreshTokenLinkURL();
        JWTResponse jwtResponse = apiProxy.post(refreshTokenLinkURL, null, JWTResponse.class);
        return this.getAuthenticationInfo(jwtResponse);
    }

    AuthenticationInfo getAuthenticationInfo(JWTResponse jwtResponse) {
        Token sessionToken = this.validateAndCreateToken(jwtResponse.getSessionJwt());
        Token refreshToken = null;
        if (StringUtils.isNotBlank((CharSequence)jwtResponse.getRefreshJwt())) {
            refreshToken = this.validateAndCreateToken(jwtResponse.getRefreshJwt());
        }
        return new AuthenticationInfo(sessionToken, refreshToken, jwtResponse.getUser(), jwtResponse.getFirstSeen());
    }

    @Override
    public List<String> getTenantIds(Token token) {
        if (MapUtils.isEmpty(token.getClaims())) {
            return Collections.emptyList();
        }
        Map claims = token.getClaims();
        if (claims.get("tenants") == null) {
            return Collections.emptyList();
        }
        claims = (Map)claims.get("tenants");
        return new ArrayList<String>(claims.keySet());
    }

    boolean isTenantAssociated(Token token, String tenant) {
        return this.getTenantIds(token).contains(tenant);
    }

    List<String> getAuthorizationClaimItems(Token token, String tenant, String root) {
        List res;
        if (MapUtils.isEmpty(token.getClaims())) {
            return Collections.emptyList();
        }
        Map claims = token.getClaims();
        if (StringUtils.isNotBlank((CharSequence)tenant)) {
            if (claims.get("tenants") == null) {
                return Collections.emptyList();
            }
            if ((claims = (Map)claims.get("tenants")).get(tenant) == null) {
                return Collections.emptyList();
            }
            claims = (Map)claims.get(tenant);
        }
        return (res = (List)claims.get(root)) == null ? Collections.emptyList() : res;
    }

    private URI composeRefreshTokenLinkURL() {
        return this.getUri("/v1/auth/refresh");
    }
}

