/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.fga.FGACheckResult;
import com.descope.model.fga.FGARelation;
import com.descope.model.fga.FGAResourceDetails;
import com.descope.model.fga.FGAResourceIdentifier;
import com.descope.model.fga.FGASchema;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.FGAService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class FGAServiceImpl
extends ManagementsBase
implements FGAService {
    FGAServiceImpl(Client client) {
        super(client);
    }

    @Override
    public void saveSchema(FGASchema schema) throws DescopeException {
        if (schema == null || StringUtils.isBlank((CharSequence)schema.getDsl())) {
            throw ServerCommonException.invalidArgument("FGA schema DSL");
        }
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("dsl", schema.getDsl());
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/fga/schema"), requestBody, Void.class);
    }

    @Override
    public FGASchema loadSchema() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, Object> response = apiProxy.getArray(this.getUri("/v1/mgmt/fga/schema"), new TypeReference<Map<String, Object>>(){});
        FGASchema schema = new FGASchema();
        if (response.containsKey("dsl")) {
            schema.setDsl((String)response.get("dsl"));
        }
        return schema;
    }

    @Override
    public void createRelations(List<FGARelation> relations) throws DescopeException {
        if (relations == null || relations.isEmpty()) {
            throw ServerCommonException.invalidArgument("relations list");
        }
        HashMap<String, List<FGARelation>> requestBody = new HashMap<String, List<FGARelation>>();
        requestBody.put("tuples", relations);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/fga/relations"), requestBody, Void.class);
    }

    @Override
    public void deleteRelations(List<FGARelation> relations) throws DescopeException {
        if (relations == null || relations.isEmpty()) {
            throw ServerCommonException.invalidArgument("relations list");
        }
        HashMap<String, List<FGARelation>> requestBody = new HashMap<String, List<FGARelation>>();
        requestBody.put("tuples", relations);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/fga/relations/delete"), requestBody, Void.class);
    }

    @Override
    public List<FGACheckResult> check(List<FGARelation> relations) throws DescopeException {
        if (relations == null || relations.isEmpty()) {
            throw ServerCommonException.invalidArgument("relations list");
        }
        HashMap<String, List<FGARelation>> requestBody = new HashMap<String, List<FGARelation>>();
        requestBody.put("tuples", relations);
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, Object> response = apiProxy.postAndGetArray(this.getUri("/v1/mgmt/fga/check"), requestBody, new TypeReference<Map<String, Object>>(){});
        if (response.containsKey("tuples")) {
            List tuples = (List)response.get("tuples");
            ArrayList<FGACheckResult> results = new ArrayList<FGACheckResult>();
            for (Map tuple : tuples) {
                FGACheckResult result = new FGACheckResult();
                if (tuple.containsKey("allowed")) {
                    result.setAllowed((Boolean)tuple.get("allowed"));
                }
                results.add(result);
            }
            return results;
        }
        return new ArrayList<FGACheckResult>();
    }

    @Override
    public List<FGAResourceDetails> loadResourcesDetails(List<FGAResourceIdentifier> resourceIdentifiers) throws DescopeException {
        if (resourceIdentifiers == null || resourceIdentifiers.isEmpty()) {
            throw ServerCommonException.invalidArgument("resource identifiers list");
        }
        HashMap<String, List<FGAResourceIdentifier>> requestBody = new HashMap<String, List<FGAResourceIdentifier>>();
        requestBody.put("resourceIdentifiers", resourceIdentifiers);
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, Object> response = apiProxy.postAndGetArray(this.getUri("/v1/mgmt/fga/resources/load"), requestBody, new TypeReference<Map<String, Object>>(){});
        if (response.containsKey("resourcesDetails")) {
            List details = (List)response.get("resourcesDetails");
            ArrayList<FGAResourceDetails> results = new ArrayList<FGAResourceDetails>();
            for (Map detail : details) {
                FGAResourceDetails resourceDetail = new FGAResourceDetails();
                if (detail.containsKey("resourceId")) {
                    resourceDetail.setResourceId((String)detail.get("resourceId"));
                }
                if (detail.containsKey("resourceType")) {
                    resourceDetail.setResourceType((String)detail.get("resourceType"));
                }
                if (detail.containsKey("displayName")) {
                    resourceDetail.setDisplayName((String)detail.get("displayName"));
                }
                results.add(resourceDetail);
            }
            return results;
        }
        return new ArrayList<FGAResourceDetails>();
    }

    @Override
    public void saveResourcesDetails(List<FGAResourceDetails> resourcesDetails) throws DescopeException {
        if (resourcesDetails == null || resourcesDetails.isEmpty()) {
            throw ServerCommonException.invalidArgument("resources details list");
        }
        HashMap<String, List<FGAResourceDetails>> requestBody = new HashMap<String, List<FGAResourceDetails>>();
        requestBody.put("resourcesDetails", resourcesDetails);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/fga/resources/save"), requestBody, Void.class);
    }
}

