/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.inbound.InboundApp;
import com.descope.model.inbound.InboundAppConsentDeleteOptions;
import com.descope.model.inbound.InboundAppConsentSearchOptions;
import com.descope.model.inbound.InboundAppConsentSearchResponse;
import com.descope.model.inbound.InboundAppCreateResponse;
import com.descope.model.inbound.InboundAppRequest;
import com.descope.model.inbound.InboundAppSecret;
import com.descope.model.inbound.InboundAppTenantConsentDeleteOptions;
import com.descope.model.inbound.LoadAllApplicationsResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.InboundAppsService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import com.descope.utils.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InboundAppsServiceImpl
extends ManagementsBase
implements InboundAppsService {
    InboundAppsServiceImpl(Client client) {
        super(client);
    }

    @Override
    public InboundAppCreateResponse createApplication(InboundAppRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getName())) {
            throw ServerCommonException.invalidArgument("request.name");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/thirdparty/app/create"), request, InboundAppCreateResponse.class);
    }

    @Override
    public void updateApplication(InboundAppRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getId())) {
            throw ServerCommonException.invalidArgument("request.id");
        }
        if (StringUtils.isBlank((CharSequence)request.getName())) {
            throw ServerCommonException.invalidArgument("request.name");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/thirdparty/app/update"), request, Void.class);
    }

    @Override
    public void patchApplication(InboundAppRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getId())) {
            throw ServerCommonException.invalidArgument("request.id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/thirdparty/app/patch"), request, Void.class);
    }

    @Override
    public void deleteApplication(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/thirdparty/app/delete"), CollectionUtils.mapOf("id", id), Void.class);
    }

    @Override
    public InboundApp loadApplication(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getQueryParamUri("/v1/mgmt/thirdparty/app/load", CollectionUtils.mapOf("id", id)), InboundApp.class);
    }

    @Override
    public InboundApp loadApplicationByClientId(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getQueryParamUri("/v1/mgmt/thirdparty/app/load", CollectionUtils.mapOf("clientId", id)), InboundApp.class);
    }

    @Override
    public String getApplicationSecret(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        InboundAppSecret clearText = apiProxy.get(this.getQueryParamUri("/v1/mgmt/thirdparty/app/secret", CollectionUtils.mapOf("id", id)), InboundAppSecret.class);
        return clearText.getSecret();
    }

    @Override
    public String rotateApplicationSecret(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        InboundAppSecret clearText = apiProxy.post(this.getUri("/v1/mgmt/thirdparty/app/rotate"), CollectionUtils.mapOf("id", id), InboundAppSecret.class);
        return clearText.getSecret();
    }

    @Override
    public InboundApp[] loadAllApplications() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        LoadAllApplicationsResponse res = apiProxy.get(this.getUri("/v1/mgmt/thirdparty/apps/load"), LoadAllApplicationsResponse.class);
        return res.getApps();
    }

    @Override
    public void deleteConsents(InboundAppConsentDeleteOptions options) throws DescopeException {
        if (options == null) {
            throw ServerCommonException.invalidArgument("options");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/thirdparty/consents/delete"), options, Void.class);
    }

    @Override
    public void deleteTenantConsents(InboundAppTenantConsentDeleteOptions options) throws DescopeException {
        if (options == null) {
            throw ServerCommonException.invalidArgument("options");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/thirdparty/consents/delete/tenant"), options, Void.class);
    }

    @Override
    public InboundAppConsentSearchResponse searchConsents(InboundAppConsentSearchOptions options) throws DescopeException {
        if (options == null) {
            throw ServerCommonException.invalidArgument("options");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/thirdparty/consents/search"), options, InboundAppConsentSearchResponse.class);
    }
}

