/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.customattributes.CreateCustomAttributesRequest;
import com.descope.model.customattributes.CustomAttribute;
import com.descope.model.customattributes.CustomAttributesResponse;
import com.descope.model.customattributes.DeleteCustomAttributesRequest;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.UserCustomAttributesService;
import com.descope.sdk.mgmt.impl.ManagementsBase;

class UserCustomAttributesServiceImpl
extends ManagementsBase
implements UserCustomAttributesService {
    UserCustomAttributesServiceImpl(Client client) {
        super(client);
    }

    @Override
    public CustomAttributesResponse getCustomAttributes() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getUri("/v1/mgmt/user/customattributes"), CustomAttributesResponse.class);
    }

    @Override
    public CustomAttributesResponse createCustomAttributes(CreateCustomAttributesRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("Request");
        }
        if (request.getAttributes() == null || request.getAttributes().isEmpty()) {
            throw ServerCommonException.invalidArgument("attributes");
        }
        for (CustomAttribute ca : request.getAttributes()) {
            if (ca.getName().isEmpty()) {
                throw ServerCommonException.invalidArgument("attribute name");
            }
            if (ca.getType() <= 0 || ca.getType() > 6) {
                throw ServerCommonException.invalidArgument("attribute type");
            }
            if (ca.getType() != 4 && ca.getType() != 5 && ca.getOptions() != null && !ca.getOptions().isEmpty()) {
                throw ServerCommonException.invalidArgument("attribute options");
            }
            if (ca.getType() != 4 && ca.getType() != 5 || ca.getOptions() != null && !ca.getOptions().isEmpty()) continue;
            throw ServerCommonException.invalidArgument("attribute options");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/user/customattribute/create"), request, CustomAttributesResponse.class);
    }

    @Override
    public CustomAttributesResponse deleteCustomAttributes(DeleteCustomAttributesRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("Request");
        }
        if (request.getNames() == null || request.getNames().isEmpty()) {
            throw ServerCommonException.invalidArgument("names");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/user/customattribute/delete"), request, CustomAttributesResponse.class);
    }
}

