/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.outbound.DeleteOutboundAppUserTokensRequest;
import com.descope.model.outbound.FetchLatestOutboundAppUserTokenRequest;
import com.descope.model.outbound.FetchOutboundAppTenantTokenRequest;
import com.descope.model.outbound.FetchOutboundAppTenantTokenResponse;
import com.descope.model.outbound.FetchOutboundAppUserTokenRequest;
import com.descope.model.outbound.FetchOutboundAppUserTokenResponse;
import com.descope.model.outbound.LoadAllOutboundApplicationsResponse;
import com.descope.model.outbound.OutboundApp;
import com.descope.model.outbound.OutboundAppCreateResponse;
import com.descope.model.outbound.OutboundAppRequest;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.OutboundAppsService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import com.descope.utils.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OutboundAppsServiceImpl
extends ManagementsBase
implements OutboundAppsService {
    OutboundAppsServiceImpl(Client client) {
        super(client);
    }

    @Override
    public OutboundAppCreateResponse createApplication(OutboundAppRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getName())) {
            throw ServerCommonException.invalidArgument("request.name");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/outbound/app/create"), request, OutboundAppCreateResponse.class);
    }

    @Override
    public void updateApplication(OutboundAppRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getId())) {
            throw ServerCommonException.invalidArgument("request.id");
        }
        if (StringUtils.isBlank((CharSequence)request.getName())) {
            throw ServerCommonException.invalidArgument("request.name");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/outbound/app/update"), request, Void.class);
    }

    @Override
    public void deleteApplication(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/outbound/app/delete"), CollectionUtils.mapOf("id", id), Void.class);
    }

    @Override
    public OutboundApp loadApplication(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getQueryParamUri("/v1/mgmt/outbound/app", CollectionUtils.mapOf("id", id)), OutboundApp.class);
    }

    @Override
    public OutboundApp[] loadAllApplications() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        LoadAllOutboundApplicationsResponse res = apiProxy.get(this.getUri("/v1/mgmt/outbound/apps"), LoadAllOutboundApplicationsResponse.class);
        return res.getApps();
    }

    @Override
    public FetchOutboundAppUserTokenResponse fetchOutboundAppUserToken(FetchOutboundAppUserTokenRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getAppId())) {
            throw ServerCommonException.invalidArgument("appId");
        }
        if (StringUtils.isBlank((CharSequence)request.getUserId())) {
            throw ServerCommonException.invalidArgument("userId");
        }
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(request.getScopes())) {
            throw ServerCommonException.invalidArgument("scopes");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/outbound/app/user/token"), request, FetchOutboundAppUserTokenResponse.class);
    }

    @Override
    public FetchOutboundAppUserTokenResponse fetchLatestOutboundAppUserToken(FetchLatestOutboundAppUserTokenRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getAppId())) {
            throw ServerCommonException.invalidArgument("appId");
        }
        if (StringUtils.isBlank((CharSequence)request.getUserId())) {
            throw ServerCommonException.invalidArgument("userId");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/outbound/app/user/token/latest"), request, FetchOutboundAppUserTokenResponse.class);
    }

    @Override
    public void deleteOutboundAppTokenById(String id) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw ServerCommonException.invalidArgument("id");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.delete(this.getUri("/v1/mgmt/outbound/token"), CollectionUtils.mapOf("id", id), Void.class);
    }

    @Override
    public void deleteOutboundAppUserTokens(DeleteOutboundAppUserTokensRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getAppId())) {
            throw ServerCommonException.invalidArgument("appId");
        }
        if (StringUtils.isBlank((CharSequence)request.getUserId())) {
            throw ServerCommonException.invalidArgument("userId");
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.delete(this.getUri("/v1/mgmt/outbound/tokens"), request, Void.class);
    }

    @Override
    public FetchOutboundAppTenantTokenResponse fetchOutboundAppTenantTokenByScopes(FetchOutboundAppTenantTokenRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getAppId())) {
            throw ServerCommonException.invalidArgument("appId");
        }
        if (StringUtils.isBlank((CharSequence)request.getTenantId())) {
            throw ServerCommonException.invalidArgument("tenantId");
        }
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(request.getScopes())) {
            throw ServerCommonException.invalidArgument("scopes");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/outbound/app/tenant/token"), request, FetchOutboundAppTenantTokenResponse.class);
    }

    @Override
    public FetchOutboundAppTenantTokenResponse fetchLatestOutboundAppTenantToken(FetchOutboundAppTenantTokenRequest request) throws DescopeException {
        if (request == null) {
            throw ServerCommonException.invalidArgument("request");
        }
        if (StringUtils.isBlank((CharSequence)request.getAppId())) {
            throw ServerCommonException.invalidArgument("appId");
        }
        if (StringUtils.isBlank((CharSequence)request.getTenantId())) {
            throw ServerCommonException.invalidArgument("tenantId");
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/outbound/app/tenant/token/latest"), request, FetchOutboundAppTenantTokenResponse.class);
    }
}

