/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.exception.ServerCommonException;
import com.descope.model.client.SdkInfo;
import com.descope.model.jwt.SigningKey;
import com.descope.model.jwt.response.SigningKeysResponse;
import com.descope.proxy.ApiProxy;
import com.descope.proxy.impl.ApiProxyBuilder;
import com.descope.utils.UriUtils;
import java.math.BigInteger;
import java.net.URI;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;

public final class KeyProvider {
    public static Key getKey(String projectId, String url, SdkInfo sdkInfo) {
        URI uri;
        ApiProxy apiProxy = ApiProxyBuilder.buildProxy(() -> "Bearer " + projectId, sdkInfo);
        SigningKeysResponse signingKeys = apiProxy.get(uri = UriUtils.addPath(UriUtils.getUri(url, "/v2/keys"), projectId), SigningKeysResponse.class);
        if (signingKeys == null || signingKeys.getKeys() == null || signingKeys.getKeys().size() < 1) {
            throw ServerCommonException.invalidSigningKey("No keys were found in the response");
        }
        SigningKey signingKey = signingKeys.getKeys().get(0);
        return KeyProvider.getPublicKey(signingKey);
    }

    private static PublicKey getPublicKey(SigningKey signingKey) {
        byte[] exponentB = Base64.getUrlDecoder().decode(signingKey.getE());
        byte[] modulusB = Base64.getUrlDecoder().decode(signingKey.getN());
        BigInteger bigExponent = new BigInteger(1, exponentB);
        BigInteger bigModulus = new BigInteger(1, modulusB);
        return KeyFactory.getInstance(signingKey.getKty()).generatePublic(new RSAPublicKeySpec(bigModulus, bigExponent));
    }

    private KeyProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

