/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.mgmt.ManagementParams;
import com.descope.model.roles.RoleResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.RolesService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class RolesServiceImpl
extends ManagementsBase
implements RolesService {
    RolesServiceImpl(Client client, ManagementParams managementParams) {
        super(client, managementParams);
    }

    @Override
    public void create(String name, String description, List<String> permissionNames) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("Name");
        }
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("name", name);
        request.put("description", description);
        if (permissionNames != null) {
            request.put("permissionNames", permissionNames);
        }
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/role/create"), request, Void.class);
    }

    @Override
    public void update(String name, String newName, String description, List<String> permissionNames) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("Name");
        }
        if (StringUtils.isBlank((CharSequence)newName)) {
            throw ServerCommonException.invalidArgument("NewName");
        }
        Map<String, List<String>> request = Map.of("name", name, "newName", newName, "description", description, "permissionNames", permissionNames);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/role/update"), request, Void.class);
    }

    @Override
    public void delete(String name) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("Name");
        }
        Map<String, String> request = Map.of("name", name);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/role/delete"), request, Void.class);
    }

    @Override
    public RoleResponse loadAll() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getUri("/v1/mgmt/role/all"), RoleResponse.class);
    }
}

