/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.authz.HasRelationsResponse;
import com.descope.model.authz.LoadSchemaResponse;
import com.descope.model.authz.Modified;
import com.descope.model.authz.Namespace;
import com.descope.model.authz.Relation;
import com.descope.model.authz.RelationDefinition;
import com.descope.model.authz.RelationQuery;
import com.descope.model.authz.RelationsResponse;
import com.descope.model.authz.ResourcesResponse;
import com.descope.model.authz.Schema;
import com.descope.model.authz.WhoCanAccessResponse;
import com.descope.model.client.Client;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.AuthzService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import com.descope.utils.CollectionUtils;
import java.time.Instant;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class AuthzServiceImpl
extends ManagementsBase
implements AuthzService {
    AuthzServiceImpl(Client client) {
        super(client);
    }

    @Override
    public void saveSchema(Schema schema, boolean upgrade) throws DescopeException {
        if (schema == null) {
            throw ServerCommonException.invalidArgument("schema");
        }
        if (schema.getNamespaces() == null || schema.getNamespaces().isEmpty()) {
            throw ServerCommonException.invalidArgument("schema");
        }
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, Boolean> request = CollectionUtils.mapOf("schema", schema, "upgrade", upgrade);
        apiProxy.post(this.getUri("/v1/mgmt/authz/schema/save"), request, Void.class);
    }

    @Override
    public void deleteSchema() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        Map request = Collections.emptyMap();
        apiProxy.post(this.getUri("/v1/mgmt/authz/schema/delete"), request, Void.class);
    }

    @Override
    public Schema loadSchema() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        Map request = Collections.emptyMap();
        LoadSchemaResponse resp = apiProxy.post(this.getUri("/v1/mgmt/authz/schema/load"), request, LoadSchemaResponse.class);
        return resp.getSchema();
    }

    @Override
    public void saveNamespace(Namespace namespace, String oldName, String schemaName) throws DescopeException {
        if (namespace == null || StringUtils.isBlank((CharSequence)namespace.getName()) || namespace.getRelationDefinitions() == null || namespace.getRelationDefinitions().isEmpty()) {
            throw ServerCommonException.invalidArgument("namespace");
        }
        ApiProxy apiProxy = this.getApiProxy();
        HashMap<String, Namespace> request = new HashMap<String, Namespace>(CollectionUtils.mapOf("namespace", namespace));
        if (!StringUtils.isBlank((CharSequence)oldName)) {
            request.put("oldName", (Namespace)((Object)oldName));
        }
        if (!StringUtils.isBlank((CharSequence)schemaName)) {
            request.put("schemaName", (Namespace)((Object)schemaName));
        }
        apiProxy.post(this.getUri("/v1/mgmt/authz/ns/save"), request, Void.class);
    }

    @Override
    public void deleteNamespace(String name, String schemaName) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("name");
        }
        ApiProxy apiProxy = this.getApiProxy();
        HashMap<String, String> request = new HashMap<String, String>(CollectionUtils.mapOf("name", name));
        if (!StringUtils.isBlank((CharSequence)schemaName)) {
            request.put("schemaName", schemaName);
        }
        apiProxy.post(this.getUri("/v1/mgmt/authz/ns/delete"), request, Void.class);
    }

    @Override
    public void saveRelationDefinition(RelationDefinition relationDefinition, String namespace, String oldName, String schemaName) throws DescopeException {
        if (relationDefinition == null || StringUtils.isBlank((CharSequence)relationDefinition.getName())) {
            throw ServerCommonException.invalidArgument("relationDefinition");
        }
        if (StringUtils.isBlank((CharSequence)namespace)) {
            throw ServerCommonException.invalidArgument("namespace");
        }
        ApiProxy apiProxy = this.getApiProxy();
        HashMap<String, String> request = new HashMap<String, String>(CollectionUtils.mapOf("relationDefinition", relationDefinition, "namespace", namespace));
        if (!StringUtils.isBlank((CharSequence)oldName)) {
            request.put("oldName", oldName);
        }
        if (!StringUtils.isBlank((CharSequence)schemaName)) {
            request.put("schemaName", schemaName);
        }
        apiProxy.post(this.getUri("/v1/mgmt/authz/rd/save"), request, Void.class);
    }

    @Override
    public void deleteRelationDefinition(String name, String namespace, String schemaName) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("name");
        }
        if (StringUtils.isBlank((CharSequence)namespace)) {
            throw ServerCommonException.invalidArgument("namespace");
        }
        ApiProxy apiProxy = this.getApiProxy();
        HashMap<String, String> request = new HashMap<String, String>(CollectionUtils.mapOf("name", name, "namespace", namespace));
        if (!StringUtils.isBlank((CharSequence)schemaName)) {
            request.put("schemaName", schemaName);
        }
        apiProxy.post(this.getUri("/v1/mgmt/authz/rd/delete"), request, Void.class);
    }

    @Override
    public void createRelations(List<Relation> relations) throws DescopeException {
        if (relations == null || relations.isEmpty()) {
            throw ServerCommonException.invalidArgument("relations");
        }
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, List<Relation>> request = CollectionUtils.mapOf("relations", relations);
        apiProxy.post(this.getUri("/v1/mgmt/authz/re/create"), request, Void.class);
    }

    @Override
    public void deleteRelations(List<Relation> relations) throws DescopeException {
        if (relations == null || relations.isEmpty()) {
            throw ServerCommonException.invalidArgument("relations");
        }
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, List<Relation>> request = CollectionUtils.mapOf("relations", relations);
        apiProxy.post(this.getUri("/v1/mgmt/authz/re/delete"), request, Void.class);
    }

    @Override
    public void deleteRelationsForResources(List<String> resources) throws DescopeException {
        if (resources == null || resources.isEmpty()) {
            throw ServerCommonException.invalidArgument("resources");
        }
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, List<String>> request = CollectionUtils.mapOf("resources", resources);
        apiProxy.post(this.getUri("/v1/mgmt/authz/re/deleteresources"), request, Void.class);
    }

    @Override
    public List<RelationQuery> hasRelations(List<RelationQuery> relationQueries) throws DescopeException {
        if (relationQueries == null || relationQueries.isEmpty()) {
            throw ServerCommonException.invalidArgument("relationQueries");
        }
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, List<RelationQuery>> request = CollectionUtils.mapOf("relationQueries", relationQueries);
        HasRelationsResponse resp = apiProxy.post(this.getUri("/v1/mgmt/authz/re/has"), request, HasRelationsResponse.class);
        return resp.getRelationQueries();
    }

    @Override
    public List<String> whoCanAccess(String resource, String relationDefinition, String namespace) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)resource)) {
            throw ServerCommonException.invalidArgument("resource");
        }
        if (StringUtils.isBlank((CharSequence)relationDefinition)) {
            throw ServerCommonException.invalidArgument("relationDefinition");
        }
        if (StringUtils.isBlank((CharSequence)namespace)) {
            throw ServerCommonException.invalidArgument("namespace");
        }
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, String> request = CollectionUtils.mapOf("resource", resource, "relationDefinition", relationDefinition, "namespace", namespace);
        WhoCanAccessResponse resp = apiProxy.post(this.getUri("/v1/mgmt/authz/re/who"), request, WhoCanAccessResponse.class);
        return resp.getTargets();
    }

    @Override
    public List<Relation> resourceRelations(String resource) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)resource)) {
            throw ServerCommonException.invalidArgument("resource");
        }
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, String> request = CollectionUtils.mapOf("resource", resource);
        RelationsResponse resp = apiProxy.post(this.getUri("/v1/mgmt/authz/re/resource"), request, RelationsResponse.class);
        return resp.getRelations();
    }

    @Override
    public List<Relation> targetsRelations(List<String> targets) throws DescopeException {
        if (targets == null || targets.isEmpty()) {
            throw ServerCommonException.invalidArgument("targets");
        }
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, List<String>> request = CollectionUtils.mapOf("targets", targets);
        RelationsResponse resp = apiProxy.post(this.getUri("/v1/mgmt/authz/re/targets"), request, RelationsResponse.class);
        return resp.getRelations();
    }

    @Override
    public List<Relation> whatCanTargetAccess(String target) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)target)) {
            throw ServerCommonException.invalidArgument("target");
        }
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, String> request = CollectionUtils.mapOf("target", target);
        RelationsResponse resp = apiProxy.post(this.getUri("/v1/mgmt/authz/re/targetall"), request, RelationsResponse.class);
        return resp.getRelations();
    }

    @Override
    public List<Relation> whatCanTargetAccessWithRelation(String target, String relationDefinition, String namespace) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)target)) {
            throw ServerCommonException.invalidArgument("target");
        }
        if (StringUtils.isBlank((CharSequence)relationDefinition)) {
            throw ServerCommonException.invalidArgument("relationDefinition");
        }
        if (StringUtils.isBlank((CharSequence)namespace)) {
            throw ServerCommonException.invalidArgument("namespace");
        }
        ApiProxy apiProxy = this.getApiProxy();
        Map<String, String> request = CollectionUtils.mapOf("target", target, "relationDefinition", relationDefinition, "namespace", namespace);
        ResourcesResponse resp = apiProxy.post(this.getUri("/v1/mgmt/authz/re/targetwithrelation"), request, ResourcesResponse.class);
        ArrayList<Relation> relations = new ArrayList<Relation>(resp != null && resp.getResources() != null ? resp.getResources().size() : 0);
        for (String resource : resp.getResources()) {
            relations.add(Relation.builder().resource(resource).target(target).relationDefinition(relationDefinition).namespace(namespace).build());
        }
        return relations;
    }

    @Override
    public Modified getModified(Instant since) throws DescopeException {
        Instant now = Instant.now();
        if (since != null && (since.isBefore(now.minus(Period.ofDays(1))) || since.isAfter(now))) {
            throw ServerCommonException.invalidArgument("since");
        }
        HashMap<String, Long> request = new HashMap<String, Long>();
        if (since != null) {
            request.put("since", since.toEpochMilli());
        }
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(this.getUri("/v1/mgmt/authz/getmodified"), request, Modified.class);
    }
}

