/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.auth.AuthParams;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.auth.ExchangeTokenRequest;
import com.descope.model.client.Client;
import com.descope.model.jwt.Token;
import com.descope.model.jwt.response.JWTResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.auth.impl.AuthenticationsBase;
import java.net.URI;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;

class AuthenticationServiceImpl
extends AuthenticationsBase {
    AuthenticationServiceImpl(Client client, AuthParams authParams) {
        super(client, authParams);
    }

    @Override
    public Token validateSessionWithToken(String sessionToken) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)sessionToken)) {
            throw ServerCommonException.invalidArgument("sessionToken");
        }
        return this.validateJWT(sessionToken);
    }

    @Override
    public Token refreshSessionWithToken(String refreshToken) throws DescopeException {
        if (Strings.isEmpty((CharSequence)refreshToken)) {
            throw ServerCommonException.missingArguments("Request doesn't contain refresh token");
        }
        return this.refreshSession(refreshToken);
    }

    @Override
    public Token validateAndRefreshSessionWithTokens(String sessionToken, String refreshToken) throws DescopeException {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{sessionToken, refreshToken})) {
            throw ServerCommonException.missingArguments("Both sessionToken and refreshToken are empty");
        }
        if (StringUtils.isNotBlank((CharSequence)sessionToken)) {
            try {
                return this.validateSessionWithToken(sessionToken);
            }
            catch (Exception e) {
                if (StringUtils.isNotBlank((CharSequence)refreshToken)) {
                    return this.refreshSessionWithToken(refreshToken);
                }
                throw e;
            }
        }
        return this.refreshSessionWithToken(refreshToken);
    }

    @Override
    public Token exchangeAccessKey(String accessKey) throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy(accessKey);
        URI exchangeAccessKeyLinkURL = this.composeExchangeAccessKeyLinkURL();
        JWTResponse jwtResponse = apiProxy.post(exchangeAccessKeyLinkURL, null, JWTResponse.class);
        AuthenticationInfo authenticationInfo = this.getAuthenticationInfo(jwtResponse);
        return authenticationInfo.getToken();
    }

    @Override
    public boolean validatePermissions(Token token, List<String> permissions) throws DescopeException {
        return this.validatePermissions(token, "", permissions);
    }

    @Override
    public boolean validatePermissions(Token token, String tenant, List<String> permissions) throws DescopeException {
        if (StringUtils.isNotBlank((CharSequence)tenant) && !this.isTenantAssociated(token, tenant)) {
            return false;
        }
        List<String> grantedPermissions = this.getPermissions(token, tenant);
        return CollectionUtils.isSubCollection(permissions, grantedPermissions);
    }

    @Override
    public boolean validateRoles(Token token, List<String> roles) throws DescopeException {
        return this.validateRoles(token, "", roles);
    }

    @Override
    public boolean validateRoles(Token token, String tenant, List<String> roles) throws DescopeException {
        if (StringUtils.isNotBlank((CharSequence)tenant) && !this.isTenantAssociated(token, tenant)) {
            return false;
        }
        List<String> grantedRoles = this.getRoles(token, tenant);
        return CollectionUtils.isSubCollection(roles, grantedRoles);
    }

    @Override
    public List<String> getRoles(Token token, String tenant) throws DescopeException {
        return this.getAuthorizationClaimItems(token, tenant, "roles");
    }

    @Override
    public List<String> getRoles(Token token) throws DescopeException {
        return this.getAuthorizationClaimItems(token, "", "roles");
    }

    @Override
    public List<String> getPermissions(Token token, String tenant) throws DescopeException {
        return this.getAuthorizationClaimItems(token, tenant, "permissions");
    }

    @Override
    public List<String> getPermissions(Token token) throws DescopeException {
        return this.getAuthorizationClaimItems(token, "", "permissions");
    }

    @Override
    public void logout(String refreshToken) throws DescopeException {
        if (Strings.isEmpty((CharSequence)refreshToken)) {
            throw ServerCommonException.missingArguments("Request doesn't contain refresh token");
        }
        ApiProxy apiProxy = this.getApiProxy(refreshToken);
        URI logOutURL = this.composeLogOutLinkURL();
        apiProxy.post(logOutURL, null, JWTResponse.class);
    }

    @Override
    public void logoutAll(String refreshToken) throws DescopeException {
        if (Strings.isEmpty((CharSequence)refreshToken)) {
            throw ServerCommonException.missingArguments("Request doesn't contain refresh token");
        }
        ApiProxy apiProxy = this.getApiProxy(refreshToken);
        URI logOutAllURL = this.composeLogOutAllLinkURL();
        apiProxy.post(logOutAllURL, null, JWTResponse.class);
    }

    AuthenticationInfo exchangeToken(String code, URI url) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw ServerCommonException.invalidArgument("Code");
        }
        ExchangeTokenRequest request = new ExchangeTokenRequest(code);
        ApiProxy apiProxy = this.getApiProxy();
        JWTResponse jwtResponse = apiProxy.post(url, request, JWTResponse.class);
        return this.getAuthenticationInfo(jwtResponse);
    }

    private URI composeExchangeAccessKeyLinkURL() {
        return this.getUri("/v1/auth/accesskey/exchange");
    }

    private URI composeLogOutLinkURL() {
        return this.getUri("/v1/auth/logout");
    }

    private URI composeLogOutAllLinkURL() {
        return this.getUri("/v1/auth/logoutall");
    }
}

