/*
 * Decompiled with CFR 0.152.
 */
package com.descope.model.client;

import com.descope.model.client.ClientParams;
import com.descope.model.client.SdkInfo;
import com.descope.model.jwt.Provider;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;

public class Client {
    private String uri;
    private Map<String, String> headers;
    private ClientParams params;
    private SdkInfo sdkInfo;
    private Provider provider;

    public synchronized Key getProvidedKey() {
        return this.provider.getProvidedKey();
    }

    public synchronized void setProvidedKey(Key key) {
        this.provider.setProvidedKey(key);
    }

    private static Provider $default$provider() {
        return Provider.builder().keyMap(new HashMap<String, Key>()).build();
    }

    public static ClientBuilder builder() {
        return new ClientBuilder();
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public ClientParams getParams() {
        return this.params;
    }

    public SdkInfo getSdkInfo() {
        return this.sdkInfo;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setParams(ClientParams params) {
        this.params = params;
    }

    public void setSdkInfo(SdkInfo sdkInfo) {
        this.sdkInfo = sdkInfo;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Client)) {
            return false;
        }
        Client other = (Client)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        ClientParams this$params = this.getParams();
        ClientParams other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        SdkInfo this$sdkInfo = this.getSdkInfo();
        SdkInfo other$sdkInfo = other.getSdkInfo();
        if (this$sdkInfo == null ? other$sdkInfo != null : !((Object)this$sdkInfo).equals(other$sdkInfo)) {
            return false;
        }
        Provider this$provider = this.getProvider();
        Provider other$provider = other.getProvider();
        return !(this$provider == null ? other$provider != null : !((Object)this$provider).equals(other$provider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Client;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        ClientParams $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        SdkInfo $sdkInfo = this.getSdkInfo();
        result = result * 59 + ($sdkInfo == null ? 43 : ((Object)$sdkInfo).hashCode());
        Provider $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : ((Object)$provider).hashCode());
        return result;
    }

    public String toString() {
        return "Client(uri=" + this.getUri() + ", headers=" + this.getHeaders() + ", params=" + this.getParams() + ", sdkInfo=" + this.getSdkInfo() + ", provider=" + this.getProvider() + ")";
    }

    public Client() {
        this.provider = Client.$default$provider();
    }

    public Client(String uri, Map<String, String> headers, ClientParams params, SdkInfo sdkInfo, Provider provider) {
        this.uri = uri;
        this.headers = headers;
        this.params = params;
        this.sdkInfo = sdkInfo;
        this.provider = provider;
    }

    public static class ClientBuilder {
        private String uri;
        private Map<String, String> headers;
        private ClientParams params;
        private SdkInfo sdkInfo;
        private boolean provider$set;
        private Provider provider$value;

        ClientBuilder() {
        }

        public ClientBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public ClientBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public ClientBuilder params(ClientParams params) {
            this.params = params;
            return this;
        }

        public ClientBuilder sdkInfo(SdkInfo sdkInfo) {
            this.sdkInfo = sdkInfo;
            return this;
        }

        public ClientBuilder provider(Provider provider) {
            this.provider$value = provider;
            this.provider$set = true;
            return this;
        }

        public Client build() {
            Provider provider$value = this.provider$value;
            if (!this.provider$set) {
                provider$value = Client.$default$provider();
            }
            return new Client(this.uri, this.headers, this.params, this.sdkInfo, provider$value);
        }

        public String toString() {
            return "Client.ClientBuilder(uri=" + this.uri + ", headers=" + this.headers + ", params=" + this.params + ", sdkInfo=" + this.sdkInfo + ", provider$value=" + this.provider$value + ")";
        }
    }
}

