/*
 * Decompiled with CFR 0.152.
 */
package com.descope.client;

import com.descope.utils.EnvironmentUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Config {
    private String projectId;
    private String managementKey;
    private String publicKey;
    private String descopeBaseUrl;
    private Map<String, String> customDefaultHeaders;
    private boolean sessionJWTViaCookie;
    private String sessionJWTCookieDomain;

    public String initializeProjectId() {
        if (StringUtils.isBlank((CharSequence)this.projectId)) {
            this.projectId = EnvironmentUtils.getProjectId();
        }
        return this.projectId;
    }

    public String initializePublicKey() {
        if (StringUtils.isBlank((CharSequence)this.publicKey)) {
            this.publicKey = EnvironmentUtils.getPublicKey();
        }
        return this.publicKey;
    }

    public String initializeManagementKey() {
        if (StringUtils.isBlank((CharSequence)this.managementKey)) {
            this.managementKey = EnvironmentUtils.getManagementKey();
        }
        return this.managementKey;
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getManagementKey() {
        return this.managementKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getDescopeBaseUrl() {
        return this.descopeBaseUrl;
    }

    public Map<String, String> getCustomDefaultHeaders() {
        return this.customDefaultHeaders;
    }

    public boolean isSessionJWTViaCookie() {
        return this.sessionJWTViaCookie;
    }

    public String getSessionJWTCookieDomain() {
        return this.sessionJWTCookieDomain;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setManagementKey(String managementKey) {
        this.managementKey = managementKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setDescopeBaseUrl(String descopeBaseUrl) {
        this.descopeBaseUrl = descopeBaseUrl;
    }

    public void setCustomDefaultHeaders(Map<String, String> customDefaultHeaders) {
        this.customDefaultHeaders = customDefaultHeaders;
    }

    public void setSessionJWTViaCookie(boolean sessionJWTViaCookie) {
        this.sessionJWTViaCookie = sessionJWTViaCookie;
    }

    public void setSessionJWTCookieDomain(String sessionJWTCookieDomain) {
        this.sessionJWTCookieDomain = sessionJWTCookieDomain;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSessionJWTViaCookie() != other.isSessionJWTViaCookie()) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$managementKey = this.getManagementKey();
        String other$managementKey = other.getManagementKey();
        if (this$managementKey == null ? other$managementKey != null : !this$managementKey.equals(other$managementKey)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$descopeBaseUrl = this.getDescopeBaseUrl();
        String other$descopeBaseUrl = other.getDescopeBaseUrl();
        if (this$descopeBaseUrl == null ? other$descopeBaseUrl != null : !this$descopeBaseUrl.equals(other$descopeBaseUrl)) {
            return false;
        }
        Map<String, String> this$customDefaultHeaders = this.getCustomDefaultHeaders();
        Map<String, String> other$customDefaultHeaders = other.getCustomDefaultHeaders();
        if (this$customDefaultHeaders == null ? other$customDefaultHeaders != null : !((Object)this$customDefaultHeaders).equals(other$customDefaultHeaders)) {
            return false;
        }
        String this$sessionJWTCookieDomain = this.getSessionJWTCookieDomain();
        String other$sessionJWTCookieDomain = other.getSessionJWTCookieDomain();
        return !(this$sessionJWTCookieDomain == null ? other$sessionJWTCookieDomain != null : !this$sessionJWTCookieDomain.equals(other$sessionJWTCookieDomain));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSessionJWTViaCookie() ? 79 : 97);
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $managementKey = this.getManagementKey();
        result = result * 59 + ($managementKey == null ? 43 : $managementKey.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $descopeBaseUrl = this.getDescopeBaseUrl();
        result = result * 59 + ($descopeBaseUrl == null ? 43 : $descopeBaseUrl.hashCode());
        Map<String, String> $customDefaultHeaders = this.getCustomDefaultHeaders();
        result = result * 59 + ($customDefaultHeaders == null ? 43 : ((Object)$customDefaultHeaders).hashCode());
        String $sessionJWTCookieDomain = this.getSessionJWTCookieDomain();
        result = result * 59 + ($sessionJWTCookieDomain == null ? 43 : $sessionJWTCookieDomain.hashCode());
        return result;
    }

    public String toString() {
        return "Config(projectId=" + this.getProjectId() + ", managementKey=" + this.getManagementKey() + ", publicKey=" + this.getPublicKey() + ", descopeBaseUrl=" + this.getDescopeBaseUrl() + ", customDefaultHeaders=" + this.getCustomDefaultHeaders() + ", sessionJWTViaCookie=" + this.isSessionJWTViaCookie() + ", sessionJWTCookieDomain=" + this.getSessionJWTCookieDomain() + ")";
    }

    public Config() {
    }

    public Config(String projectId, String managementKey, String publicKey, String descopeBaseUrl, Map<String, String> customDefaultHeaders, boolean sessionJWTViaCookie, String sessionJWTCookieDomain) {
        this.projectId = projectId;
        this.managementKey = managementKey;
        this.publicKey = publicKey;
        this.descopeBaseUrl = descopeBaseUrl;
        this.customDefaultHeaders = customDefaultHeaders;
        this.sessionJWTViaCookie = sessionJWTViaCookie;
        this.sessionJWTCookieDomain = sessionJWTCookieDomain;
    }

    public static class ConfigBuilder {
        private String projectId;
        private String managementKey;
        private String publicKey;
        private String descopeBaseUrl;
        private Map<String, String> customDefaultHeaders;
        private boolean sessionJWTViaCookie;
        private String sessionJWTCookieDomain;

        ConfigBuilder() {
        }

        public ConfigBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public ConfigBuilder managementKey(String managementKey) {
            this.managementKey = managementKey;
            return this;
        }

        public ConfigBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public ConfigBuilder descopeBaseUrl(String descopeBaseUrl) {
            this.descopeBaseUrl = descopeBaseUrl;
            return this;
        }

        public ConfigBuilder customDefaultHeaders(Map<String, String> customDefaultHeaders) {
            this.customDefaultHeaders = customDefaultHeaders;
            return this;
        }

        public ConfigBuilder sessionJWTViaCookie(boolean sessionJWTViaCookie) {
            this.sessionJWTViaCookie = sessionJWTViaCookie;
            return this;
        }

        public ConfigBuilder sessionJWTCookieDomain(String sessionJWTCookieDomain) {
            this.sessionJWTCookieDomain = sessionJWTCookieDomain;
            return this;
        }

        public Config build() {
            return new Config(this.projectId, this.managementKey, this.publicKey, this.descopeBaseUrl, this.customDefaultHeaders, this.sessionJWTViaCookie, this.sessionJWTCookieDomain);
        }

        public String toString() {
            return "Config.ConfigBuilder(projectId=" + this.projectId + ", managementKey=" + this.managementKey + ", publicKey=" + this.publicKey + ", descopeBaseUrl=" + this.descopeBaseUrl + ", customDefaultHeaders=" + this.customDefaultHeaders + ", sessionJWTViaCookie=" + this.sessionJWTViaCookie + ", sessionJWTCookieDomain=" + this.sessionJWTCookieDomain + ")";
        }
    }
}

