/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk;

import com.descope.model.client.Client;
import com.descope.utils.UriUtils;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public abstract class SdkServicesBase {
    protected final Client client;

    protected SdkServicesBase(Client client) {
        this.client = client;
    }

    protected URI composeURI(String base, String path) {
        URI uri = this.getUri(base);
        return UriUtils.addPath(uri, path);
    }

    protected URI getUri(String path) {
        return UriUtils.getUri(this.client.getUri(), path);
    }

    protected URI getQueryParamUri(String path, Map<String, String> params) {
        if (ObjectUtils.isNotEmpty(params)) {
            String queryParams = params.entrySet().stream().map(p -> String.valueOf((String)p.getKey()) + "=" + (String)p.getValue()).reduce((p1, p2) -> String.valueOf(p1) + "&" + p2).orElse("");
            return UriUtils.getUri(this.client.getUri(), path.concat("?" + queryParams));
        }
        return UriUtils.getUri(this.client.getUri(), path);
    }
}

