/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.exception.DescopeException;
import com.descope.model.auth.AuthParams;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.client.Client;
import com.descope.model.magiclink.LoginOptions;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.auth.OAuthService;
import com.descope.sdk.auth.impl.AuthenticationServiceImpl;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

class OAuthServiceImpl
extends AuthenticationServiceImpl
implements OAuthService {
    OAuthServiceImpl(Client client, AuthParams authParams) {
        super(client, authParams);
    }

    @Override
    public String start(String provider, String redirectURL, LoginOptions loginOptions) throws DescopeException {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("provider", provider);
        if (StringUtils.isNotBlank((CharSequence)redirectURL)) {
            request.put("redirectURL", redirectURL);
        }
        URI oauthURL = this.composeOAuthURL();
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.post(oauthURL, request, String.class);
    }

    @Override
    public AuthenticationInfo exchangeToken(String code) throws DescopeException {
        return this.exchangeToken(code, this.composeOAuthExchangeTokenURL());
    }

    private URI composeOAuthURL() {
        return this.getUri("/v1/auth/oauth/authorize");
    }

    private URI composeOAuthExchangeTokenURL() {
        return this.getUri("/v1/auth/oauth/exchange");
    }
}

