/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.auth.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.auth.AuthParams;
import com.descope.model.auth.AuthenticationInfo;
import com.descope.model.client.Client;
import com.descope.model.jwt.response.JWTResponse;
import com.descope.model.password.AuthenticationPasswordReplaceRequestBody;
import com.descope.model.password.AuthenticationPasswordResetRequestBody;
import com.descope.model.password.AuthenticationPasswordSignInRequestBody;
import com.descope.model.password.AuthenticationPasswordSignUpRequestBody;
import com.descope.model.password.AuthenticationPasswordUpdateRequestBody;
import com.descope.model.password.PasswordPolicy;
import com.descope.model.user.User;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.auth.PasswordService;
import com.descope.sdk.auth.impl.AuthenticationServiceImpl;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

class PasswordServiceImpl
extends AuthenticationServiceImpl
implements PasswordService {
    PasswordServiceImpl(Client client, AuthParams authParams) {
        super(client, authParams);
    }

    @Override
    public AuthenticationInfo signUp(String loginId, User user, String password) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (Objects.isNull(user)) {
            user = new User();
        }
        AuthenticationPasswordSignUpRequestBody pwdSignUpRequest = AuthenticationPasswordSignUpRequestBody.builder().loginId(loginId).user(user).password(password).build();
        ApiProxy apiProxy = this.getApiProxy();
        JWTResponse jwtResponse = apiProxy.post(this.getUri("/v1/auth/password/signup"), pwdSignUpRequest, JWTResponse.class);
        return this.getAuthenticationInfo(jwtResponse);
    }

    @Override
    public AuthenticationInfo signIn(String loginId, String password) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        AuthenticationPasswordSignInRequestBody pwdSignInRequest = AuthenticationPasswordSignInRequestBody.builder().loginId(loginId).password(password).build();
        ApiProxy apiProxy = this.getApiProxy();
        JWTResponse jwtResponse = apiProxy.post(this.getUri("/v1/auth/password/signin"), pwdSignInRequest, JWTResponse.class);
        return this.getAuthenticationInfo(jwtResponse);
    }

    @Override
    public void sendPasswordReset(String loginId, String redirectURL) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        AuthenticationPasswordResetRequestBody pwdResetRequest = AuthenticationPasswordResetRequestBody.builder().loginId(loginId).redirectURL(redirectURL).build();
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/auth/password/reset"), pwdResetRequest, Void.class);
    }

    @Override
    public void updateUserPassword(String loginId, String newPassword, String refreshToken) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        if (StringUtils.isBlank((CharSequence)refreshToken)) {
            throw ServerCommonException.invalidArgument("Refresh Token");
        }
        AuthenticationPasswordUpdateRequestBody pwdUpdateRequest = AuthenticationPasswordUpdateRequestBody.builder().loginId(loginId).newPassword(newPassword).build();
        ApiProxy apiProxy = this.getApiProxy(refreshToken);
        apiProxy.post(this.getUri("/v1/auth/password/update"), pwdUpdateRequest, Void.class);
    }

    @Override
    public void replaceUserPassword(String loginId, String oldPassword, String newPassword) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)loginId)) {
            throw ServerCommonException.invalidArgument("Login ID");
        }
        AuthenticationPasswordReplaceRequestBody pwdUpdateRequest = AuthenticationPasswordReplaceRequestBody.builder().loginId(loginId).oldPassword(oldPassword).newPassword(newPassword).build();
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/auth/password/replace"), pwdUpdateRequest, Void.class);
    }

    @Override
    public PasswordPolicy getPasswordPolicy() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getUri("/v1/auth/password/policy"), PasswordPolicy.class);
    }
}

