/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.jwt.request.UpdateJwtRequest;
import com.descope.model.jwt.response.JWTResponse;
import com.descope.model.mgmt.ManagementParams;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.JwtService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class JwtServiceImpl
extends ManagementsBase
implements JwtService {
    JwtServiceImpl(Client client, ManagementParams managementParams) {
        super(client, managementParams);
    }

    @Override
    public String updateJWTWithCustomClaims(String jwt, Map<String, Object> customClaims) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)jwt)) {
            throw ServerCommonException.invalidArgument("JWT");
        }
        UpdateJwtRequest updateJwtRequest = new UpdateJwtRequest(jwt, customClaims);
        URI updateJwtUri = this.composeUpdateJwtUri();
        ApiProxy apiProxy = this.getApiProxy();
        JWTResponse jwtResponse = apiProxy.post(updateJwtUri, updateJwtRequest, JWTResponse.class);
        return jwtResponse.getSessionJwt();
    }

    private URI composeUpdateJwtUri() {
        return this.getUri("/v1/mgmt/jwt/update");
    }
}

