/*
 * Decompiled with CFR 0.152.
 */
package com.descope.sdk.mgmt.impl;

import com.descope.exception.DescopeException;
import com.descope.exception.ServerCommonException;
import com.descope.model.client.Client;
import com.descope.model.mgmt.ManagementParams;
import com.descope.model.permission.PermissionResponse;
import com.descope.proxy.ApiProxy;
import com.descope.sdk.mgmt.PermissionService;
import com.descope.sdk.mgmt.impl.ManagementsBase;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class PermissionServiceImpl
extends ManagementsBase
implements PermissionService {
    PermissionServiceImpl(Client client, ManagementParams managementParams) {
        super(client, managementParams);
    }

    @Override
    public void create(String name, String description) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("Name");
        }
        Map<String, String> request = Map.of("name", name, "description", description);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/permission/create"), request, Void.class);
    }

    @Override
    public void update(String name, String newName, String description) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("Name");
        }
        if (StringUtils.isBlank((CharSequence)newName)) {
            throw ServerCommonException.invalidArgument("NewName");
        }
        Map<String, String> request = Map.of("name", name, "newName", newName, "description", description);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/permission/update"), request, Void.class);
    }

    @Override
    public void delete(String name) throws DescopeException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ServerCommonException.invalidArgument("Name");
        }
        Map<String, String> request = Map.of("name", name);
        ApiProxy apiProxy = this.getApiProxy();
        apiProxy.post(this.getUri("/v1/mgmt/permission/delete"), request, Void.class);
    }

    @Override
    public PermissionResponse loadAll() throws DescopeException {
        ApiProxy apiProxy = this.getApiProxy();
        return apiProxy.get(this.getUri("/v1/mgmt/permission/all"), PermissionResponse.class);
    }
}

