/*
 * Decompiled with CFR 0.152.
 */
package com.descope.utils;

import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class UriUtils {
    public static URI addPath(URI uri, String path) {
        String newPath = path.startsWith("/") ? path.replaceAll("//+", "/") : (uri.getPath().endsWith("/") ? String.valueOf(uri.getPath()) + path.replaceAll("//+", "/") : String.valueOf(uri.getPath()) + "/" + path.replaceAll("//+", "/"));
        return uri.resolve(newPath).normalize();
    }

    public static URI getUri(String url, String path) {
        return URI.create(String.valueOf(url) + (path.startsWith("/") ? path : "/" + path));
    }

    public static Map<String, List<String>> splitQuery(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return Collections.emptyMap();
        }
        URL newUrl = new URL(url);
        return UriUtils.splitQuery(newUrl);
    }

    public static Map<String, List<String>> splitQuery(URL url) {
        if (StringUtils.isBlank((CharSequence)url.getQuery())) {
            return Collections.emptyMap();
        }
        return Arrays.stream(url.getQuery().split("&")).map(UriUtils::splitQueryParameter).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    public static AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String it) {
        int idx = it.indexOf("=");
        String key = idx > 0 ? it.substring(0, idx) : it;
        String value = idx > 0 && it.length() > idx + 1 ? it.substring(idx + 1) : null;
        return new AbstractMap.SimpleImmutableEntry<String, String>(URLDecoder.decode(key, StandardCharsets.UTF_8), URLDecoder.decode(value, StandardCharsets.UTF_8));
    }

    private UriUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

