/*
 * Decompiled with CFR 0.152.
 */
package com.despegar.khronus.jclient;

import com.despegar.khronus.jclient.JsonSerializer;
import com.despegar.khronus.jclient.KhronusConfig;
import com.despegar.khronus.jclient.Measure;
import com.despegar.khronus.jclient.Sender;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Buffer {
    private static final Logger LOG = LoggerFactory.getLogger(Buffer.class);
    private final LinkedBlockingQueue<Measure> measures;
    private final ScheduledExecutorService executor;
    private final Sender sender;
    private JsonSerializer jsonSerializer;

    public Buffer(KhronusConfig config) {
        this.measures = new LinkedBlockingQueue(config.getMaximumMeasures());
        this.sender = new Sender(config);
        this.jsonSerializer = new JsonSerializer(config.getSendIntervalMillis(), config.getApplicationName());
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("KhronusClientSender").build();
        this.executor = Executors.newScheduledThreadPool(1, (ThreadFactory)threadFactory);
        this.executor.scheduleWithFixedDelay(this.send(), config.getSendIntervalMillis(), config.getSendIntervalMillis(), TimeUnit.MILLISECONDS);
        LOG.debug("Buffer to store metrics created [MaximumMeasures: {}; SendIntervalMillis: {}]", (Object)config.getMaximumMeasures(), (Object)config.getSendIntervalMillis());
    }

    public void add(Measure measure) {
        if (!this.measures.offer(measure)) {
            LOG.warn("Could not add measure because the buffer is full. Measure discarted: " + measure.getMetricName());
        }
    }

    private Runnable send() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (!Buffer.this.measures.isEmpty()) {
                        LOG.debug("Sending metrics to Khronus...");
                        ArrayList<Measure> copiedMeasures = new ArrayList<Measure>();
                        Buffer.this.measures.drainTo(copiedMeasures);
                        String json = Buffer.this.jsonSerializer.serialize(copiedMeasures);
                        LOG.trace("Json to be posted to Khronus: {}", (Object)json);
                        Buffer.this.sender.send(json);
                        LOG.debug("Metrics sent successfully to Khronus");
                    }
                }
                catch (Throwable reason) {
                    LOG.warn("Error sending metrics to Khronus", reason);
                }
            }
        };
    }
}

