/*
 * Decompiled with CFR 0.152.
 */
package com.despegar.khronus.jclient;

import com.despegar.khronus.jclient.Measure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(JsonSerializer.class);
    private static final double PERCETANGE_OFINTERVAL_FORSERIALIZATION = 0.7;
    private static final long BATCH_SIZE_TOCHECK_TIMEOUT = 5000L;
    private final double sendIntervalMillis;
    private String applicationName;

    public JsonSerializer(Long sendIntervalMillis, String applicationName) {
        this.sendIntervalMillis = sendIntervalMillis.longValue();
        this.applicationName = applicationName;
    }

    public String serialize(Collection<Measure> measures) {
        long deadlineForSerialization = this.getDeadlineForSerialization();
        Map<String, Collection<Measure>> groupedByMetric = this.groupByMetric(measures);
        StringBuilder json = new StringBuilder("{ \"metrics\": [");
        long count = 0L;
        for (Map.Entry<String, Collection<Measure>> metric : groupedByMetric.entrySet()) {
            json.append(this.toJson(metric.getKey(), metric.getValue()));
            if (++count != (long)groupedByMetric.size()) {
                json.append(",");
            }
            if (!this.hasTimeout(deadlineForSerialization, count)) continue;
            LOG.warn("Timeout was reached during serialization of metrics. Some will be discarted");
            break;
        }
        return json.append("]}").toString();
    }

    private Map<String, Collection<Measure>> groupByMetric(Collection<Measure> measures) {
        HashMap<String, Collection<Measure>> groupedByMetric = new HashMap<String, Collection<Measure>>();
        for (Measure measure : measures) {
            ArrayList<Measure> measuresByMetric = (ArrayList<Measure>)groupedByMetric.get(measure.getMetricName());
            if (measuresByMetric == null) {
                measuresByMetric = new ArrayList<Measure>();
                groupedByMetric.put(measure.getMetricName(), measuresByMetric);
            }
            measuresByMetric.add(measure);
        }
        return groupedByMetric;
    }

    private String toJson(String metricName, Collection<Measure> measures) {
        StringBuilder json = new StringBuilder();
        json.append(String.format("{ \"name\":\"%s\", \"mtype\":\"%s\", \"measurements\":[", new Object[]{this.getUniqueMetricName(metricName), measures.iterator().next().getType()}));
        int nMeasures = 0;
        for (Measure measure : measures) {
            json.append(String.format("{ \"ts\":%d, \"values\": [%s] }", measure.getTimestamp(), measure.getValue()));
            if (++nMeasures == measures.size()) continue;
            json.append(",");
        }
        json.append("]}");
        return json.toString();
    }

    protected String getUniqueMetricName(String metricName) {
        if (StringUtils.isEmpty((CharSequence)this.applicationName)) {
            return metricName;
        }
        return this.applicationName + ":" + metricName;
    }

    private boolean hasTimeout(long deadlineForSerialization, long count) {
        return count % 5000L == 0L && System.currentTimeMillis() > deadlineForSerialization;
    }

    private long getDeadlineForSerialization() {
        return System.currentTimeMillis() + new Double(this.sendIntervalMillis * 0.7).longValue();
    }
}

