/*
 * Decompiled with CFR 0.152.
 */
package com.despegar.khronus.jclient;

import com.despegar.khronus.jclient.Buffer;
import com.despegar.khronus.jclient.Counter;
import com.despegar.khronus.jclient.Gauge;
import com.despegar.khronus.jclient.KhronusConfig;
import com.despegar.khronus.jclient.Timer;
import org.apache.commons.lang3.StringUtils;

public class KhronusClient {
    private static final long DEFAULT_INCREMENT = 1L;
    private Buffer buffer;

    private KhronusClient(Builder builder) {
        this.buffer = new Buffer(new KhronusConfig(builder.applicationName, builder.maximumMeasures, builder.sendIntervalMillis, builder.hosts, builder.maxConnections));
    }

    public void recordTime(String metricName, long time) {
        this.recordTime(metricName, time, System.currentTimeMillis());
    }

    public void recordTime(String metricName, long time, long timestamp) {
        this.buffer.add(new Timer(metricName, time, timestamp));
    }

    public void incrementCounter(String metricName) {
        this.incrementCounter(metricName, 1L);
    }

    public void incrementCounter(String metricName, long counts) {
        this.incrementCounter(metricName, counts, System.currentTimeMillis());
    }

    public void incrementCounter(String metricName, long counts, long timestamp) {
        this.buffer.add(new Counter(metricName, counts, timestamp));
    }

    public void recordGauge(String metricName, long value) {
        this.recordGauge(metricName, value, System.currentTimeMillis());
    }

    public void recordGauge(String metricName, long value, long timestamp) {
        this.buffer.add(new Gauge(metricName, value, timestamp));
    }

    public static class Builder {
        String[] hosts;
        long sendIntervalMillis = 5000L;
        int maximumMeasures = 500000;
        int maxConnections = 50;
        String applicationName;

        public Builder withHosts(String hosts) {
            this.hosts = hosts.split(",");
            return this;
        }

        public Builder withSendIntervalMillis(long interval) {
            this.sendIntervalMillis = interval;
            return this;
        }

        public Builder withMaximumMeasures(int max) {
            this.maximumMeasures = max;
            return this;
        }

        public Builder withMaxConnections(int max) {
            this.maxConnections = max;
            return this;
        }

        public Builder withApplicationName(String appName) {
            this.applicationName = StringUtils.join((Object[])new String[]{appName});
            return this;
        }

        public KhronusClient build() {
            this.validate();
            return new KhronusClient(this);
        }

        private void validate() {
            if (this.hosts == null | this.hosts.length == 0) {
                throw new RuntimeException("Fail to build KhronusClient. Please provide a host to send metrics to Khronus");
            }
        }
    }
}

